/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.FXSourceOrbital;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalCollector;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.crystal.CollectorCrystalType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationTile;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeTile;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.IndependentCrystalSource;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.base.network.TileSourceBase;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCollectorCrystal
extends TileSourceBase<SimpleTransmissionSourceNode>
implements CrystalAttributeTile,
ConstellationTile {
    public static final BlockPos[] OFFSETS_LIQUID_STARLIGHT = new BlockPos[]{new BlockPos(-1, -4, -1), new BlockPos(0, -4, -1), new BlockPos(1, -4, -1), new BlockPos(1, -4, 0), new BlockPos(1, -4, 1), new BlockPos(0, -4, 1), new BlockPos(-1, -4, 1), new BlockPos(-1, -4, 0)};
    private UUID playerUUID = null;
    private CrystalAttributes crystalAttributes;
    private CollectorCrystalType collectorType = CollectorCrystalType.ROCK_CRYSTAL;
    private IWeakConstellation constellationType;
    private IMinorConstellation constellationTrait;
    private Object[] effectOrbitals = new Object[4];

    public TileCollectorCrystal() {
        super(TileEntityTypesAS.COLLECTOR_CRYSTAL);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            this.doesSeeSky();
            this.hasMultiblock();
        } else {
            this.playEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        Vector3 thisPos = new Vector3(this).add(0.5f, 0.5f, 0.5f);
        Vector3 particlePos = thisPos.clone();
        MiscUtils.applyRandomOffset(particlePos, rand, 0.75f);
        if (this.isEnhanced() && this.doesSeeSky() && this.getCollectorType() == CollectorCrystalType.CELESTIAL_CRYSTAL && this.getAttunedConstellation() != null) {
            Color c = this.getAttunedConstellation().getConstellationColor();
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(particlePos)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setAlphaMultiplier(0.8f)).color(VFXColorFunction.constant(c))).setMaxAge(20 + rand.nextInt(10));
            for (int i = 0; i < this.effectOrbitals.length; ++i) {
                FXOrbitalCollector fxSource = (FXOrbitalCollector)this.effectOrbitals[i];
                if (fxSource == null) {
                    FXSourceOrbital src = new FXOrbitalCollector(new Vector3(this).add(0.5f, 0.5f, 0.5f), c).setOrbitAxis(Vector3.random()).setOrbitRadius(0.8f + rand.nextFloat() * 0.5f).setTicksPerRotation(40 + rand.nextInt(30));
                    EffectHelper.spawnSource(src);
                    this.effectOrbitals[i] = src;
                    continue;
                }
                if (!fxSource.canRemove() || !fxSource.isRemoved()) continue;
                this.effectOrbitals[i] = null;
            }
            BlockPos starlightSource = MiscUtils.getRandomEntry(OFFSETS_LIQUID_STARLIGHT, rand).func_177971_a((Vec3i)this.func_174877_v());
            Vector3 from = new Vector3((Vec3i)starlightSource).add(rand.nextFloat(), 0.85f, rand.nextFloat());
            Vector3 motion = thisPos.clone().subtract(from).normalize().multiply(0.08f);
            Color particleColor = MiscUtils.eitherOf(rand, Color.WHITE, c, c.brighter());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(from)).setMotion(motion)).alpha(VFXAlphaFunction.proximity(thisPos::clone, 2.0f).andThen(VFXAlphaFunction.FADE_OUT))).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.constant(particleColor))).setMaxAge(30 + rand.nextInt(10));
            if (rand.nextInt(80) == 0) {
                ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(thisPos)).makeDefault(from).color(VFXColorFunction.constant(c));
            }
        } else if (rand.nextBoolean()) {
            Color c = this.getCollectorType().getDisplayColor();
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(particlePos)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setAlphaMultiplier(0.8f)).color(VFXColorFunction.constant(c))).setMaxAge(20 + rand.nextInt(10));
        }
    }

    public boolean isEnhanced() {
        return this.getCollectorType() == CollectorCrystalType.CELESTIAL_CRYSTAL && this.hasMultiblock();
    }

    public boolean isPlayerMade() {
        return this.getPlayerUUID() != null;
    }

    @Override
    public IWeakConstellation getAttunedConstellation() {
        return this.constellationType;
    }

    @Override
    public boolean setAttunedConstellation(@Nullable IWeakConstellation cst) {
        if (cst != this.constellationType) {
            this.markForUpdate();
        }
        this.constellationType = cst;
        return true;
    }

    @Override
    public IMinorConstellation getTraitConstellation() {
        return this.constellationTrait;
    }

    @Override
    public boolean setTraitConstellation(@Nullable IMinorConstellation cst) {
        if (cst != this.constellationTrait) {
            this.markForUpdate();
        }
        this.constellationTrait = cst;
        return true;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes() {
        return this.crystalAttributes;
    }

    @Override
    public void setAttributes(@Nullable CrystalAttributes attributes) {
        if (this.crystalAttributes == null && attributes == null) {
            return;
        }
        if (attributes == null || !attributes.equals(this.crystalAttributes)) {
            this.markForUpdate();
        }
        this.crystalAttributes = attributes;
    }

    public CollectorCrystalType getCollectorType() {
        return this.collectorType;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void updateData(UUID playerUUID, CollectorCrystalType collectorType) {
        this.playerUUID = playerUUID;
        this.collectorType = collectorType;
        if (this.collectorType == null) {
            this.collectorType = CollectorCrystalType.ROCK_CRYSTAL;
        }
        this.markForUpdate();
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        if (this.collectorType == CollectorCrystalType.CELESTIAL_CRYSTAL) {
            return StructureTypesAS.PTYPE_ENHANCED_COLLECTOR_CRYSTAL;
        }
        return null;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.constellationType = NBTHelper.readOptional(compound, "constellationType", nbt -> {
            IConstellation cst = IConstellation.readFromNBT(nbt);
            if (cst instanceof IWeakConstellation) {
                return (IWeakConstellation)cst;
            }
            return null;
        });
        this.constellationTrait = NBTHelper.readOptional(compound, "constellationTrait", nbt -> {
            IConstellation cst = IConstellation.readFromNBT(nbt);
            if (cst instanceof IMinorConstellation) {
                return (IMinorConstellation)cst;
            }
            return null;
        });
        this.setAttributes(CrystalAttributes.getCrystalAttributes(compound));
        this.crystalAttributes = CrystalAttributes.getCrystalAttributes(compound);
        this.collectorType = NBTHelper.readEnum(compound, "collectorType", CollectorCrystalType.class);
        this.playerUUID = NBTHelper.readOptional(compound, "playerUUID", nbt -> nbt.func_186857_a("playerUUID"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        if (this.getAttributes() != null) {
            this.getAttributes().store(compound);
        }
        NBTHelper.writeOptional(compound, "constellationType", this.constellationType, (nbt, cst) -> cst.writeToNBT((CompoundNBT)nbt));
        NBTHelper.writeOptional(compound, "constellationTrait", this.constellationTrait, (nbt, cst) -> cst.writeToNBT((CompoundNBT)nbt));
        NBTHelper.writeEnum(compound, "collectorType", this.collectorType);
        NBTHelper.writeOptional(compound, "playerUUID", this.playerUUID, (nbt, uuid) -> nbt.func_186854_a("playerUUID", uuid));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BOX.func_186662_g(1.0).func_186670_a(this.func_174877_v());
    }

    @Override
    @Nonnull
    public IIndependentStarlightSource provideNewSourceNode() {
        return new IndependentCrystalSource();
    }

    @Override
    @Nonnull
    public SimpleTransmissionSourceNode provideSourceNode(BlockPos at) {
        return new SimpleTransmissionSourceNode(at);
    }
}

