/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.effect.vfx.FXSpritePlane;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeTile;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.base.TileAreaOfInfluence;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.network.TileReceiverBase;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverRitualPedestal;
import hellfirepvp.astralsorcery.common.util.EffectIncrementer;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventoryFiltered;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileRitualPedestal
extends TileReceiverBase<StarlightReceiverRitualPedestal>
implements CrystalAttributeTile,
TileAreaOfInfluence {
    public static final BlockPos RITUAL_ANCHOR_OFFEST = new BlockPos(0, 5, 0);
    public static final Set<BlockPos> RITUAL_CIRCLE_OFFSETS;
    public static final int MAX_MIRROR_COUNT = 5;
    private TileInventoryFiltered inventory;
    private final Map<BlockPos, BlockState> offsetConfigurations = new HashMap<BlockPos, BlockState>();
    private UUID ownerUUID = null;
    private BlockPos ritualLinkTo = null;
    private boolean working = false;
    private Map<BlockPos, Boolean> offsetMirrors = new HashMap<BlockPos, Boolean>();
    private EffectIncrementer effectWork = new EffectIncrementer(64);
    private ConstellationEffect clientEffectInstance = null;
    private Object ritualHaloEffect = null;

    public TileRitualPedestal() {
        super(TileEntityTypesAS.RITUAL_PEDESTAL);
        this.inventory = new TileInventoryFiltered((TileEntitySynchronized)this, () -> 1, Direction.DOWN);
        this.inventory.canExtract((slot, amount, existing) -> !existing.func_190926_b());
        this.inventory.canInsert((slot, toAdd, existing) -> existing.func_190926_b() && toAdd.func_77973_b() instanceof ItemAttunedCrystalBase && ((ItemAttunedCrystalBase)toAdd.func_77973_b()).getFocusConstellation(toAdd) != null);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            this.doesSeeSky();
            this.hasMultiblock();
            this.updateLinkTile();
            this.updateBlockConfigurations();
        }
        this.effectWork.update(this.working);
        if (this.func_145831_w().func_201670_d() && this.working) {
            this.playEffects();
        }
    }

    private void updateBlockConfigurations() {
        if (this.ticksExisted % 20 == 0) {
            for (BlockPos offset : RITUAL_CIRCLE_OFFSETS) {
                BlockPos pos = this.func_174877_v().func_177971_a((Vec3i)offset);
                MiscUtils.executeWithChunk((IWorldReader)this.func_145831_w(), pos, pos, at -> {
                    BlockState savedState = this.offsetConfigurations.get(offset);
                    if (this.func_145831_w().func_175623_d(at)) {
                        if (savedState != null) {
                            this.offsetConfigurations.remove(offset);
                            this.markForUpdate();
                        }
                    } else {
                        BlockState actualState = this.func_145831_w().func_180495_p(at);
                        if (savedState == null || !savedState.equals(actualState)) {
                            this.offsetConfigurations.put(offset, actualState);
                            this.markForUpdate();
                        }
                    }
                });
            }
        }
    }

    private void updateLinkTile() {
        boolean hasLinkNow;
        boolean hasLink = this.ritualLinkTo != null;
        BlockPos link = this.func_174877_v().func_177971_a((Vec3i)RITUAL_ANCHOR_OFFEST);
        TileRitualLink linkTile = MiscUtils.getTileAt((IBlockReader)this.field_145850_b, link, TileRitualLink.class, true);
        if (linkTile != null) {
            this.ritualLinkTo = linkTile.getLinkedTo();
            hasLinkNow = this.ritualLinkTo != null;
        } else {
            this.ritualLinkTo = null;
            hasLinkNow = false;
        }
        if (hasLink != hasLinkNow) {
            this.markForUpdate();
        }
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return StructureTypesAS.PTYPE_RITUAL_PEDESTAL;
    }

    @Nonnull
    public Set<BlockState> getConfiguredBlockStates() {
        return Sets.newHashSet(this.offsetConfigurations.values());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Color getEffectColor() {
        if (!this.providesEffect()) {
            return null;
        }
        IWeakConstellation running = this.getRitualConstellation();
        if (running == null) {
            return null;
        }
        return running.getConstellationColor();
    }

    @Override
    public float getRadius() {
        if (!this.providesEffect()) {
            return 0.0f;
        }
        IWeakConstellation running = this.getRitualConstellation();
        if (running == null) {
            return 0.0f;
        }
        ConstellationEffect effect = ConstellationEffectRegistry.createInstance(this, running);
        if (effect == null) {
            return 0.0f;
        }
        ConstellationEffectProperties properties = effect.createProperties(this.getMirrorCount());
        if (properties != null) {
            CrystalAttributes attributes;
            if (this.getRitualTrait() != null) {
                properties.modify(this.getRitualTrait());
            }
            if (!this.getCurrentCrystal().func_190926_b() && (attributes = CrystalAttributes.getCrystalAttributes(this.getCurrentCrystal())) != null) {
                properties.multiplySize(CrystalCalculations.getRitualEffectRangeFactor(this, attributes));
            }
            return (float)properties.getSize() * 1.3f;
        }
        return 0.0f;
    }

    @Override
    @Nonnull
    public BlockPos getEffectOriginPosition() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public Vector3 getEffectPosition() {
        return new Vector3((Vec3i)this.getEffectOriginPosition()).add(0.5f, 0.5f, 0.5f);
    }

    @Override
    @Nonnull
    public DimensionType getDimensionType() {
        return this.func_145831_w().func_201675_m().func_186058_p();
    }

    @Override
    public boolean providesEffect() {
        return this.isWorking() && !this.func_145837_r();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        Vector3 to;
        float alphaDaytime = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
        alphaDaytime *= 0.8f;
        float percRunning = this.effectWork.getAsPercentage();
        int chance = 15 + (int)((1.0f - percRunning) * 50.0f);
        if (rand.nextInt(chance) == 0) {
            Vector3 from = new Vector3(this).add(0.5, 0.05, 0.5);
            MiscUtils.applyRandomOffset(from, rand, 0.05f);
            ((EntityComplexFX)((FXLightbeam)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).setOwner(this.ownerUUID)).spawn(from)).setup(from.clone().addY(6.0), 1.5, 1.5).setAlphaMultiplier(0.5f + 0.5f * alphaDaytime)).setMaxAge(64);
        }
        if (this.ritualLinkTo != null && rand.nextBoolean()) {
            Vector3 at = new Vector3(this).add(0.0, 0.1, 0.0);
            at.add((double)rand.nextFloat() * 0.5 + 0.25, 0.0, (double)rand.nextFloat() * 0.5 + 0.25);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(this.ownerUUID)).spawn(at)).setAlphaMultiplier(0.7f)).color(VFXColorFunction.WHITE)).setMotion(Vector3.positiveYRandom(rand).addY(2.0).normalize().multiply(0.4f))).setScaleMultiplier(0.2f + rand.nextFloat() * 0.15f)).motion(VFXMotionController.target(() -> new Vector3(this).add((Vec3i)RITUAL_ANCHOR_OFFEST).add(0.5, 0.5, 0.5), 0.1f))).setMaxAge(30 + rand.nextInt(50));
        }
        List activeMirrors = this.offsetMirrors.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        IWeakConstellation ritualConstellation = this.getRitualConstellation();
        if (this.working && ritualConstellation != null) {
            CrystalAttributes prop;
            if (!activeMirrors.isEmpty() && DayTimeHelper.isNight(this.func_145831_w()) && rand.nextInt(chance * 2) == 0) {
                Vector3 from = new Vector3(this).add(0.5, 0.1, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 2.0f);
                from.setY((double)this.func_174877_v().func_177956_o() - 0.6 + (double)(1.0f * rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)));
                ((EntityComplexFX)((EntityVisualFX)((FXLightbeam)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).setOwner(this.ownerUUID)).spawn(from)).setup(from.clone().addY(5 + rand.nextInt(3)), 1.3f, 1.3f).setAlphaMultiplier(alphaDaytime)).color(VFXColorFunction.constant(ritualConstellation.getConstellationColor()))).setMaxAge(64);
            }
            if (this.ritualHaloEffect == null) {
                this.ritualHaloEffect = ((EntityComplexFX)((FXSpritePlane)EffectHelper.of(EffectTemplatesAS.TEXTURE_SPRITE).spawn(new Vector3(this).add(0.5, 0.05, 0.5))).setSprite(SpritesAS.SPR_HALO_RITUAL).setAxis(Vector3.RotAxis.Y_AXIS).setNoRotation(25.0f).setScaleMultiplier(6.5f)).refresh(RefreshFunction.tileExistsAnd(this, (tile, effect) -> tile.isWorking() && !tile.getCurrentCrystal().func_190926_b()));
            }
            if (this.ritualHaloEffect != null) {
                FXSpritePlane effectPlane = (FXSpritePlane)this.ritualHaloEffect;
                EffectHelper.refresh(effectPlane, EffectTemplatesAS.TEXTURE_SPRITE);
                float dayTimeMul = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
                effectPlane.setAlphaMultiplier(Math.max(0.05f, dayTimeMul * 0.75f));
            }
            Vector3 offset = Vector3.random().setY(0).normalize().multiply(rand.nextFloat() * 4.0f * (float)(rand.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(this.ownerUUID)).spawn(new Vector3(this).add(0.5, 0.02, 0.5).add(offset))).setAlphaMultiplier(1.0f)).setGravityStrength(-0.001f)).color(VFXColorFunction.constant(ritualConstellation.getConstellationColor()))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.3f + rand.nextFloat() * 0.15f)).setMaxAge(25 + rand.nextInt(15));
            if (this.clientEffectInstance != null && !this.clientEffectInstance.getConstellation().equals(ritualConstellation)) {
                this.clientEffectInstance = null;
            }
            if (this.clientEffectInstance == null) {
                this.clientEffectInstance = ConstellationEffectRegistry.createInstance(ILocatable.fromPos(this.func_174877_v()), ritualConstellation);
            }
            if (this.clientEffectInstance != null) {
                this.clientEffectInstance.playClientEffect(this.func_145831_w(), this.func_174877_v(), this, percRunning, this.isFullyEnhanced());
                if (this.ritualLinkTo != null && this.func_145831_w().func_195588_v(this.ritualLinkTo)) {
                    this.clientEffectInstance.playClientEffect(this.func_145831_w(), this.ritualLinkTo, this, percRunning, this.isFullyEnhanced());
                }
            }
            if ((prop = this.getAttributes()) != null && rand.nextInt(3) == 0) {
                for (int i = 0; i < 3; ++i) {
                    Vector3 at = new Vector3(this).add(0.5, 1.35, 0.5).add(Vector3.random().multiply(0.6f));
                    Vector3 motion = Vector3.random().multiply(0.02f);
                    ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(this.ownerUUID)).spawn(at)).setMotion(motion)).setAlphaMultiplier(1.0f)).color(VFXColorFunction.constant(ritualConstellation.getConstellationColor()))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.05f)).setMaxAge(16 + rand.nextInt(15));
                }
                if (rand.nextInt(3) == 0) {
                    Vector3 from = new Vector3(this).add(0.5, 1.2, 0.5);
                    if (activeMirrors.isEmpty()) {
                        to = new Vector3(this).add(0.5, 3.5 + (double)rand.nextFloat() * 2.5, 0.5);
                    } else {
                        BlockPos mirror = ((BlockPos)MiscUtils.getRandomEntry(activeMirrors, rand)).func_177971_a((Vec3i)this.func_174877_v());
                        to = new Vector3((Vec3i)mirror).add(0.5, 0.5, 0.5);
                    }
                    ((FXLightning)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTNING).setOwner(this.ownerUUID)).spawn(from)).makeDefault(to).color(VFXColorFunction.constant(ritualConstellation.getConstellationColor()));
                }
            }
        }
        for (BlockPos mirror : this.offsetMirrors.keySet()) {
            if (this.ticksExisted % 32 != 0) continue;
            Vector3 source = new Vector3(this).add(0.5, 0.9, 0.5);
            to = new Vector3(this).add((Vec3i)mirror).add(0.5, 0.5, 0.5);
            ((FXLightbeam)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).setOwner(this.ownerUUID)).spawn(source)).setup(to, 0.8f, 0.8f);
            if (this.ritualLinkTo == null || !this.offsetMirrors.get(mirror).booleanValue()) continue;
            source = new Vector3(this).add((Vec3i)RITUAL_ANCHOR_OFFEST).add(0.5, 0.5, 0.5);
            ((FXLightbeam)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).setOwner(this.ownerUUID)).spawn(source)).setup(to, 0.8f, 0.8f).color(VFXColorFunction.random());
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public Map<BlockPos, Boolean> getMirrors() {
        return MapStream.of(this.offsetMirrors).mapKey(pos -> pos.func_177971_a((Vec3i)this.func_174877_v())).toMap();
    }

    public int getMirrorCount() {
        return (int)this.offsetMirrors.values().stream().filter(b -> b).count();
    }

    public boolean isFullyEnhanced() {
        return this.working && this.offsetMirrors.size() == 5;
    }

    @Nullable
    public PlayerEntity getOwner() {
        if (this.ownerUUID == null || this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_217371_b(this.ownerUUID);
    }

    @Nonnull
    public ItemStack getCurrentCrystal() {
        ItemStack crystal = this.inventory.getStackInSlot(0);
        return ItemUtils.copyStackWithSize(crystal, crystal.func_190916_E());
    }

    @Nullable
    public BlockPos getRitualLinkTo() {
        return this.ritualLinkTo;
    }

    @Nonnull
    public EffectIncrementer getWorkEffectTimer() {
        return this.effectWork;
    }

    @Nullable
    public IWeakConstellation getRitualConstellation() {
        ItemStack crystal = this.inventory.getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof ConstellationItem) {
            return ((ConstellationItem)crystal.func_77973_b()).getAttunedConstellation(crystal);
        }
        return null;
    }

    @Nullable
    public IMinorConstellation getRitualTrait() {
        ItemStack crystal = this.inventory.getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof ConstellationItem) {
            return ((ConstellationItem)crystal.func_77973_b()).getTraitConstellation(crystal);
        }
        return null;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes() {
        ItemStack crystal = this.inventory.getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof CrystalAttributeItem) {
            return ((CrystalAttributeItem)crystal.func_77973_b()).getAttributes(crystal);
        }
        return null;
    }

    @Override
    public void setAttributes(@Nullable CrystalAttributes attributes) {
        ItemStack crystal = this.inventory.getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof CrystalAttributeItem) {
            ((CrystalAttributeItem)crystal.func_77973_b()).setAttributes(crystal, attributes);
        }
    }

    public void setOwner(@Nullable UUID playerUUID) {
        this.ownerUUID = playerUUID;
        this.markForUpdate();
    }

    @Nonnull
    public ItemStack tryPlaceCrystalInPedestal(@Nonnull ItemStack crystal) {
        ItemStack currentCatalyst = this.inventory.getStackInSlot(0);
        ItemStack toInsert = ItemUtils.copyStackWithSize(crystal, Math.min(crystal.func_190916_E(), 1));
        if (toInsert.func_190926_b()) {
            if (!this.inventory.canExtractItem(0, 1)) {
                return ItemStack.field_190927_a;
            }
            if (currentCatalyst.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            return currentCatalyst;
        }
        if (!this.inventory.canInsertItem(0, crystal)) {
            return crystal;
        }
        if (currentCatalyst.func_190926_b()) {
            this.inventory.setStackInSlot(0, toInsert);
            return ItemUtils.copyStackWithSize(crystal, Math.max(0, crystal.func_190916_E() - 1));
        }
        return crystal;
    }

    public void setReceiverData(boolean working, Map<BlockPos, Boolean> mirrorData, @Nullable CrystalAttributes newAttributes) {
        this.working = working;
        this.offsetMirrors = new HashMap<BlockPos, Boolean>(mirrorData);
        ItemStack crystal = this.getCurrentCrystal();
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof CrystalAttributeItem) {
            if (newAttributes == null) {
                this.tryPlaceCrystalInPedestal(ItemStack.field_190927_a);
            } else {
                this.setAttributes(newAttributes.copy());
            }
        }
        this.markForUpdate();
        this.preventNetworkSync();
    }

    @Override
    @Nonnull
    public StarlightReceiverRitualPedestal provideEndpoint(BlockPos at) {
        return new StarlightReceiverRitualPedestal(at);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
        this.ownerUUID = compound.func_186855_b("ownerUUID") ? compound.func_186857_a("ownerUUID") : null;
        this.ritualLinkTo = NBTHelper.readFromSubTag(compound, "ritualLinkTo", NBTHelper::readBlockPosFromNBT);
        this.working = compound.func_74767_n("working");
        this.offsetMirrors.clear();
        ListNBT tagList = compound.func_150295_c("mirrors", 10);
        for (INBT nbt : tagList) {
            CompoundNBT tag = (CompoundNBT)nbt;
            this.offsetMirrors.put(NBTHelper.readBlockPosFromNBT(tag), tag.func_74767_n("connect"));
        }
        this.offsetConfigurations.clear();
        ListNBT tagBlocks = compound.func_150295_c("blockConfiguration", 10);
        for (INBT nbt : tagBlocks) {
            CompoundNBT tag = (CompoundNBT)nbt;
            this.offsetConfigurations.put(NBTHelper.readBlockPosFromNBT(tag), NBTHelper.getBlockState(tag, "state"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
        if (this.ritualLinkTo != null) {
            NBTHelper.setAsSubTag(compound, "ritualLinkTo", cmp -> NBTHelper.writeBlockPosToNBT(this.ritualLinkTo, cmp));
        }
        compound.func_74757_a("working", this.working);
        ListNBT listPositions = new ListNBT();
        for (Map.Entry<BlockPos, Boolean> posEntry : this.offsetMirrors.entrySet()) {
            CompoundNBT cmp2 = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(posEntry.getKey(), cmp2);
            cmp2.func_74757_a("connect", posEntry.getValue().booleanValue());
            listPositions.add((Object)cmp2);
        }
        compound.func_218657_a("mirrors", (INBT)listPositions);
        ListNBT listConfigurations = new ListNBT();
        for (Map.Entry<BlockPos, BlockState> posEntry : this.offsetConfigurations.entrySet()) {
            CompoundNBT cmp3 = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(posEntry.getKey(), cmp3);
            NBTHelper.setBlockState(cmp3, "state", posEntry.getValue());
            listConfigurations.add((Object)cmp3);
        }
        compound.func_218657_a("blockConfiguration", (INBT)listConfigurations);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.inventory.hasCapability(cap, side)) {
            return this.inventory.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    static {
        HashSet circleOffsets = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(4, 1, 0), new BlockPos(4, 1, 1), new BlockPos(3, 1, 2), new BlockPos(2, 1, 3), new BlockPos(1, 1, 4), new BlockPos(0, 1, 4), new BlockPos(-1, 1, 4), new BlockPos(-2, 1, 3), new BlockPos(-3, 1, 2), new BlockPos(-4, 1, 1), new BlockPos(-4, 1, 0), new BlockPos(-4, 1, -1), new BlockPos(-3, 1, -2), new BlockPos(-2, 1, -3), new BlockPos(-1, 1, -4), new BlockPos(0, 1, -4), new BlockPos(1, 1, -4), new BlockPos(2, 1, -3), new BlockPos(3, 1, -2), new BlockPos(4, 1, -1)});
        HashSet ritualOffsets = new HashSet(circleOffsets);
        circleOffsets.stream().map(pos -> pos.func_177982_a(0, 1, 0)).forEach(ritualOffsets::add);
        circleOffsets.stream().map(pos -> pos.func_177982_a(0, 2, 0)).forEach(ritualOffsets::add);
        RITUAL_CIRCLE_OFFSETS = ImmutableSet.copyOf(ritualOffsets);
    }
}

