/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.effect.vfx.FXSpritePlane;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CelestialStrike {
    private static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    private CelestialStrike() {
    }

    public static void play(@Nullable LivingEntity attacker, World world, Vector3 at, Vector3 displayPosition) {
        double radius = 16.0;
        List livingEntities = world.func_175647_a(LivingEntity.class, EMPTY.func_72314_b(radius, radius / 2.0, radius).func_186670_a(at.toBlockPos()), EntityPredicates.field_94557_a);
        if (attacker != null) {
            livingEntities.remove(attacker);
        }
        DamageSource ds = CommonProxy.DAMAGE_SOURCE_STELLAR;
        if (attacker != null) {
            ds = DamageSource.func_76358_a((LivingEntity)attacker);
            if (attacker instanceof PlayerEntity) {
                ds = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
            }
        }
        float dmg = 25.0f;
        dmg += SkyCollectionHelper.getSkyNoiseDistribution(world, at.toBlockPos()) * 10.0f;
        for (LivingEntity living : livingEntities) {
            int fireAspectLevel;
            if (living instanceof PlayerEntity && (living.func_175149_v() || ((PlayerEntity)living).func_184812_l_() || attacker != null && living.func_184191_r((Entity)attacker))) continue;
            float dstPerc = (float)(Vector3.atEntityCenter((Entity)living).distance(at) / radius);
            float dmgDealt = (dstPerc = 1.0f - MathHelper.func_76131_a((float)dstPerc, (float)0.0f, (float)1.0f)) * dmg;
            if (!((double)dmgDealt > 0.5)) continue;
            DamageUtil.attackEntityFrom((Entity)living, ds, dmgDealt);
            if (attacker == null || (fireAspectLevel = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_77334_n, (LivingEntity)attacker)) <= 0 || living.func_70027_ad()) continue;
            living.func_70015_d(fireAspectLevel * 4);
        }
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.CELESTIAL_STRIKE).addData(buf -> ByteBufUtils.writeVector(buf, displayPosition));
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)world, (Vec3i)at.toBlockPos(), 96.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playEffect(PktPlayEffect effect) {
        Vector3 dir;
        int i;
        Random r = new Random();
        Vector3 vec = ByteBufUtils.readVector(effect.getExtraData());
        Vector3 effectPos = vec.clone();
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(effectPos.clone().addY(-4.0))).setup(effectPos.clone().addY(16.0), 9.0, 6.0).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.WHITE)).setAlphaMultiplier(1.0f)).setMaxAge(25);
        effectPos.add(r.nextFloat() - r.nextFloat(), 0.0f, r.nextFloat() - r.nextFloat());
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(effectPos.clone().addY(-4.0))).setup(effectPos.clone().addY(16.0).addY(r.nextFloat() * 2.0f), 9.0, 6.0).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_LIGHT))).setAlphaMultiplier(1.0f)).setMaxAge(24 + r.nextInt(6));
        effectPos.add(r.nextFloat() - r.nextFloat(), 0.0f, r.nextFloat() - r.nextFloat());
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(effectPos.clone().addY(-4.0))).setup(effectPos.clone().addY(16.0).addY(r.nextFloat() * 2.0f), 9.0, 6.0).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_DARK))).setAlphaMultiplier(1.0f)).setMaxAge(24 + r.nextInt(6));
        AbstractRenderableTexture tex = MiscUtils.eitherOf(r, TexturesAS.TEX_SMOKE_1, TexturesAS.TEX_SMOKE_2, TexturesAS.TEX_SMOKE_3, TexturesAS.TEX_SMOKE_4);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXSpritePlane)EffectHelper.of(EffectTemplatesAS.TEXTURE_SPRITE).spawn(vec.clone().addY(0.1f))).setAxis(Vector3.RotAxis.Y_AXIS.clone().negate()).setSprite(tex).setNoRotation(r.nextFloat() * 360.0f).setAlphaMultiplier(0.4f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(17.0f)).setMaxAge(30 + r.nextInt(10));
        for (i = 0; i < 43; ++i) {
            Vector3 randTo = new Vector3(r.nextDouble() * 9.0 - r.nextDouble() * 9.0, r.nextDouble() * 5.0, r.nextDouble() * 9.0 - r.nextDouble() * 9.0);
            randTo.add(vec.clone());
            FXLightning lightning = ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(vec.clone())).makeDefault(randTo);
            lightning.color(MiscUtils.eitherOf(r, VFXColorFunction.constant(Color.WHITE), VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_LIGHT), VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_DARK)));
        }
        for (i = 0; i < 40; ++i) {
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(vec.clone().add((r.nextFloat() - r.nextFloat()) * 4.0f, r.nextFloat() * 9.0f, (r.nextFloat() - r.nextFloat()) * 4.0f))).setGravityStrength(-0.005f)).setScaleMultiplier(0.85f)).setMaxAge(14 + r.nextInt(6));
            p.color(MiscUtils.eitherOf(r, VFXColorFunction.constant(Color.WHITE), VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_LIGHT), VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_DARK)));
        }
        List<Vector3> circle = MiscUtils.getCirclePositions(vec, Vector3.RotAxis.Y_AXIS, 7.5f + r.nextFloat(), 200 + r.nextInt(40));
        for (Vector3 at : circle) {
            dir = at.clone().subtract(vec).normalize().multiply(0.3 + 0.4 * (double)r.nextFloat());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setAlphaMultiplier(0.4f)).setMotion(dir)).color(VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_LIGHT))).setScaleMultiplier(1.2f)).setMaxAge(14 + r.nextInt(6));
        }
        circle = MiscUtils.getCirclePositions(vec, Vector3.RotAxis.Y_AXIS, 7.5f + r.nextFloat(), 100 + r.nextInt(40));
        for (Vector3 at : circle) {
            dir = at.clone().subtract(vec).normalize().multiply(0.2 + 0.1 * (double)r.nextFloat());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setAlphaMultiplier(0.4f)).setMotion(dir)).color(VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_DARK))).setScaleMultiplier(1.5f)).setMaxAge(14 + r.nextInt(6));
        }
    }
}

