/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class PlayerReference {
    private final UUID playerUUID;
    private final ITextComponent playerName;

    public PlayerReference(UUID playerUUID, ITextComponent playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public static PlayerReference of(PlayerEntity player) {
        return new PlayerReference(player.func_110124_au(), player.func_145748_c_());
    }

    public boolean isPlayer(PlayerEntity player) {
        return this.getPlayerUUID().equals(player.func_110124_au());
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ITextComponent getPlayerName() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerReference that = (PlayerReference)o;
        return Objects.equals(this.playerUUID, that.playerUUID);
    }

    public int hashCode() {
        return Objects.hash(this.playerUUID);
    }

    @Nullable
    public ServerPlayerEntity getOnlinePlayer() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            throw new IllegalArgumentException("Called getOnlinePlayer on clientside or while no server is running!");
        }
        return server.func_184103_al().func_177451_a(this.playerUUID);
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        this.writeToNBT(tag);
        return tag;
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_186854_a("playerUUID", this.playerUUID);
        tag.func_74778_a("playerName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.playerName));
    }

    public void write(PacketBuffer buf) {
        ByteBufUtils.writeUUID(buf, this.playerUUID);
        ByteBufUtils.writeTextComponent(buf, this.playerName);
    }

    public static PlayerReference deserialize(CompoundNBT tag) {
        return new PlayerReference(tag.func_186857_a("playerUUID"), ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i("playerName")));
    }

    public static PlayerReference read(PacketBuffer buf) {
        return new PlayerReference(ByteBufUtils.readUUID(buf), ByteBufUtils.readTextComponent(buf));
    }
}

