/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.commons.lang3.ObjectUtils;

public class RecipeHelper {
    @Nullable
    public static SimpleAltarRecipe findAltarRecipeResult(Predicate<ItemStack> match) {
        for (SimpleAltarRecipe recipe : RecipeTypesAS.TYPE_ALTAR.getAllRecipes()) {
            if (!match.test(recipe.getOutputForRender(Collections.emptyList()))) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public static Optional<ItemStack> findSmeltingResult(World world, BlockState input) {
        ItemStack stack = ItemUtils.createBlockStack(input);
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        return RecipeHelper.findSmeltingResult(world, stack);
    }

    @Nonnull
    public static Optional<ItemStack> findSmeltingResult(World world, ItemStack input) {
        RecipeManager mgr = world.func_199532_z();
        Inventory inv = new Inventory(new ItemStack[]{input});
        Optional optRecipe = (Optional)ObjectUtils.firstNonNull((Object[])new Optional[]{mgr.func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222153_e, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222152_d, (IInventory)inv, world), Optional.empty()});
        return optRecipe.map(arg_0 -> RecipeHelper.lambda$findSmeltingResult$0((IInventory)inv, arg_0));
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return RecipeHelper.getClientManager();
        }
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (srv != null) {
            return srv.func_199529_aN();
        }
        return null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private static RecipeManager getClientManager() {
        ClientPlayNetHandler conn = Minecraft.func_71410_x().func_147114_u();
        if (conn != null) {
            return conn.func_199526_e();
        }
        return null;
    }

    private static /* synthetic */ ItemStack lambda$findSmeltingResult$0(IInventory inv, IRecipe recipe) {
        return recipe.func_77572_b(inv).func_77946_l();
    }
}

