/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.TestBlockUseContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockUtils {
    @Nonnull
    public static List<ItemStack> getDrops(ServerWorld world, BlockPos pos, int harvestFortune, Random rand) {
        return BlockUtils.getDrops(world, pos, harvestFortune, rand, ItemStack.field_190927_a);
    }

    @Nonnull
    public static List<ItemStack> getDrops(ServerWorld world, BlockPos pos, int harvestFortune, Random rand, ItemStack tool) {
        return BlockUtils.getDrops(world, pos, world.func_180495_p(pos), harvestFortune, rand, tool);
    }

    @Nonnull
    public static List<ItemStack> getDrops(ServerWorld world, BlockPos pos, BlockState state, int harvestFortune, Random rand, ItemStack tool) {
        LootContext.Builder builder = new LootContext.Builder(world).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216021_b(LootParameters.field_216288_h, (Object)MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, true)).func_216023_a(rand).func_186469_a((float)harvestFortune);
        return state.func_215693_a(builder);
    }

    @Nonnull
    public static BlockPos getWorldTopPos(BlockPos at) {
        BlockPos it = at;
        while (!World.func_189509_E((BlockPos)it)) {
            it = it.func_177984_a();
        }
        return it;
    }

    public static float getSimpleBreakSpeed(LivingEntity entity, ItemStack tool, BlockState state) {
        float efficiencyLevel;
        float breakSpeed = tool.func_150997_a(state);
        if (breakSpeed > 1.0f && (efficiencyLevel = (float)EnchantmentHelper.func_185293_e((LivingEntity)entity)) > 0.0f && !tool.func_190926_b()) {
            breakSpeed += efficiencyLevel * efficiencyLevel + 1.0f;
        }
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            breakSpeed *= 1.0f + ((float)EffectUtils.func_205134_b((LivingEntity)entity) + 1.0f) * 0.2f;
        }
        if (entity.func_70644_a(Effects.field_76419_f)) {
            float fatigueMultiplier;
            switch (entity.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    fatigueMultiplier = (float)Math.pow(0.3f, 1.0);
                    break;
                }
                case 1: {
                    fatigueMultiplier = (float)Math.pow(0.3f, 2.0);
                    break;
                }
                case 2: {
                    fatigueMultiplier = (float)Math.pow(0.3f, 3.0);
                    break;
                }
                default: {
                    fatigueMultiplier = (float)Math.pow(0.3f, 4.0);
                }
            }
            breakSpeed *= fatigueMultiplier;
        }
        if (entity.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)entity)) {
            breakSpeed /= 5.0f;
        }
        if (!entity.field_70122_E) {
            breakSpeed /= 5.0f;
        }
        return breakSpeed;
    }

    public static boolean isReplaceable(World world, BlockPos pos) {
        return BlockUtils.isReplaceable(world, pos, world.func_180495_p(pos));
    }

    public static boolean isReplaceable(World world, BlockPos pos, BlockState state) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        BlockItemUseContext ctx = TestBlockUseContext.getHandContext(world, null, Hand.MAIN_HAND, pos, Direction.UP);
        return state.func_196953_a(ctx);
    }

    public static boolean isFluidBlock(World world, BlockPos pos) {
        return BlockUtils.isFluidBlock(world.func_180495_p(pos));
    }

    public static boolean isFluidBlock(BlockState state) {
        return state == state.func_204520_s().func_206883_i();
    }

    @Nullable
    public static BlockState getMatchingState(Collection<BlockState> applicableStates, @Nullable BlockState test) {
        for (BlockState state : applicableStates) {
            if (!BlockUtils.matchStateExact(state, test)) continue;
            return state;
        }
        return null;
    }

    public static boolean matchStateExact(@Nullable BlockState state, @Nullable BlockState stateToTest) {
        if (state == null) {
            return stateToTest == null;
        }
        if (stateToTest == null) {
            return false;
        }
        if (!state.func_177230_c().getRegistryName().equals((Object)stateToTest.func_177230_c().getRegistryName())) {
            return false;
        }
        for (IProperty prop : state.func_206869_a()) {
            Comparable original = state.func_177229_b(prop);
            try {
                Comparable test = stateToTest.func_177229_b(prop);
                if (original.equals(test)) continue;
                return false;
            }
            catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    public static boolean canToolBreakBlockWithoutPlayer(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ItemStack stack) {
        if (state.func_185887_b((IBlockReader)world, pos) == -1.0f) {
            return false;
        }
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return state.func_185904_a().func_76229_l() || stack.func_150998_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, null, state);
        if (toolLevel < 0) {
            return state.func_185904_a().func_76229_l() || stack.func_150998_b(state);
        }
        return toolLevel >= state.getHarvestLevel();
    }

    public static boolean breakBlockWithPlayer(BlockPos pos, ServerPlayerEntity playerMP) {
        return playerMP.field_71134_c.func_180237_b(pos);
    }

    public static boolean breakBlockWithoutPlayer(ServerWorld world, BlockPos pos) {
        return BlockUtils.breakBlockWithoutPlayer(world, pos, world.func_180495_p(pos), ItemStack.field_190927_a, true, false);
    }

    @Deprecated
    public static boolean breakBlockWithoutPlayer(ServerWorld world, BlockPos pos, BlockState stateBroken, ItemStack heldItem, boolean breakBlock, boolean ignoreHarvestRestrictions, boolean playEffects) {
        return BlockUtils.breakBlockWithoutPlayer(world, pos, stateBroken, heldItem, breakBlock, ignoreHarvestRestrictions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean breakBlockWithoutPlayer(ServerWorld world, BlockPos pos, BlockState stateBroken, ItemStack heldItem, boolean breakBlock, boolean ignoreHarvestRestrictions) {
        int xp;
        FakePlayer fakePlayer = AstralSorcery.getProxy().getASFakePlayerServer(world);
        try {
            boolean preCancelEvent = false;
            if (!heldItem.func_190926_b() && !heldItem.func_77973_b().func_195938_a(stateBroken, (World)world, pos, (PlayerEntity)fakePlayer)) {
                preCancelEvent = true;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)world, pos, stateBroken, (PlayerEntity)fakePlayer);
            event.setCanceled(preCancelEvent);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
            xp = event.getExpToDrop();
        }
        catch (Exception exc) {
            return false;
        }
        if (xp == -1) {
            return false;
        }
        if (heldItem.onBlockStartBreak(pos, (PlayerEntity)fakePlayer)) {
            return false;
        }
        boolean harvestable = true;
        try {
            if (!ignoreHarvestRestrictions) {
                harvestable = stateBroken.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)fakePlayer);
            }
        }
        catch (Exception exc) {
            return false;
        }
        ItemStack heldCopy = heldItem.func_190926_b() ? ItemStack.field_190927_a : heldItem.func_77946_l();
        try {
            heldCopy.func_179548_a((World)world, stateBroken, pos, (PlayerEntity)fakePlayer);
        }
        catch (Exception exc) {
            return false;
        }
        boolean wasCapturingStates = world.captureBlockSnapshots;
        ArrayList<BlockSnapshot> previousCapturedStates = new ArrayList<BlockSnapshot>(world.capturedBlockSnapshots);
        world.captureBlockSnapshots = true;
        try {
            if (breakBlock) {
                if (!stateBroken.removedByPlayer((World)world, pos, (PlayerEntity)fakePlayer, harvestable, Fluids.field_204541_a.func_207188_f())) {
                    BlockUtils.restoreWorldState((World)world, wasCapturingStates, previousCapturedStates);
                    return false;
                }
            } else {
                stateBroken.func_177230_c().func_176208_a((World)world, pos, stateBroken, (PlayerEntity)fakePlayer);
            }
        }
        catch (Exception exc) {
            BlockUtils.restoreWorldState((World)world, wasCapturingStates, previousCapturedStates);
            return false;
        }
        stateBroken.func_177230_c().func_176206_d((IWorld)world, pos, stateBroken);
        if (harvestable) {
            try {
                TileEntity tileentity = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, true);
                ItemStack harvestStack = heldCopy.func_190926_b() ? ItemStack.field_190927_a : heldCopy.func_77946_l();
                stateBroken.func_177230_c().func_180657_a((World)world, (PlayerEntity)fakePlayer, pos, stateBroken, tileentity, harvestStack);
            }
            catch (Exception exc) {
                BlockUtils.restoreWorldState((World)world, wasCapturingStates, previousCapturedStates);
                return false;
            }
        }
        if (xp > 0) {
            stateBroken.func_177230_c().func_180637_b((World)world, pos, xp);
        }
        BlockDropCaptureAssist.startCapturing();
        try {
            world.captureBlockSnapshots = false;
            world.restoringBlockSnapshots = true;
            world.capturedBlockSnapshots.forEach(s -> s.restore(true));
            world.restoringBlockSnapshots = false;
            world.capturedBlockSnapshots.forEach(s -> world.func_175656_a(s.getPos(), Blocks.field_150350_a.func_176223_P()));
        }
        finally {
            BlockDropCaptureAssist.getCapturedStacksAndStop();
            world.capturedBlockSnapshots.clear();
            world.captureBlockSnapshots = wasCapturingStates;
            world.capturedBlockSnapshots.addAll(previousCapturedStates);
        }
        return true;
    }

    private static void restoreWorldState(World world, boolean prevCaptureFlag, List<BlockSnapshot> prevSnapshots) {
        world.captureBlockSnapshots = false;
        world.restoringBlockSnapshots = true;
        world.capturedBlockSnapshots.forEach(s -> s.restore(true));
        world.restoringBlockSnapshots = false;
        world.capturedBlockSnapshots.clear();
        world.captureBlockSnapshots = prevCaptureFlag;
        world.capturedBlockSnapshots.addAll(prevSnapshots);
    }
}

