/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tick;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.util.tick.TimeoutList;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.event.TickEvent;

public class TimeoutListContainer<K, V>
implements ITickHandler {
    private final EnumSet<TickEvent.Type> tickTypes;
    private final ContainerTimeoutDelegate<K, V> delegate;
    private final Map<K, TimeoutList<V>> timeoutListMap = new HashMap<K, TimeoutList<V>>();

    public TimeoutListContainer(TickEvent.Type ... restTypes) {
        this((ContainerTimeoutDelegate<K, V>)null, restTypes);
    }

    public TimeoutListContainer(@Nullable ContainerTimeoutDelegate<K, V> delegate, TickEvent.Type ... types) {
        this.tickTypes = EnumSet.noneOf(TickEvent.Type.class);
        for (TickEvent.Type type : types) {
            if (type == null) continue;
            this.tickTypes.add(type);
        }
        this.delegate = delegate;
    }

    public boolean hasList(K key) {
        return this.timeoutListMap.containsKey(key);
    }

    @Nullable
    public TimeoutList<V> removeList(K key) {
        TimeoutList<V> ret = this.timeoutListMap.remove(key);
        ret.forEach(v -> this.delegate.onContainerTimeout(key, v));
        return ret;
    }

    public boolean removeList(Predicate<V> valueTest) {
        boolean removed = false;
        for (Map.Entry<K, TimeoutList<V>> entry : this.timeoutListMap.entrySet()) {
            Iterator<V> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                V value = iterator.next();
                if (!valueTest.test(value)) continue;
                this.delegate.onContainerTimeout(entry.getKey(), value);
                iterator.remove();
                removed = true;
            }
        }
        return removed;
    }

    public TimeoutList<V> getOrCreateList(K key) {
        TimeoutList<V> list = this.timeoutListMap.get(key);
        if (list == null) {
            list = new TimeoutList(new RedirectTimeoutDelegate(key, this.delegate), new TickEvent.Type[0]);
            this.timeoutListMap.put(key, list);
        }
        return list;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<Map.Entry<K, TimeoutList<V>>> it = this.timeoutListMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, TimeoutList<V>> entry = it.next();
            TimeoutList<V> list = entry.getValue();
            list.tick(type, context);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    public void clear() {
        Lists.newArrayList(this.timeoutListMap.keySet()).forEach(this::removeList);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return this.tickTypes;
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "TimeoutListContainer";
    }

    public static interface ContainerTimeoutDelegate<K, V> {
        public void onContainerTimeout(K var1, V var2);
    }

    private static class RedirectTimeoutDelegate<K, V>
    implements TimeoutList.TimeoutDelegate<V> {
        private final K key;
        private final ContainerTimeoutDelegate<K, V> delegate;

        private RedirectTimeoutDelegate(K key, @Nullable ContainerTimeoutDelegate<K, V> delegate) {
            this.key = key;
            this.delegate = delegate;
        }

        @Override
        public void onTimeout(V object) {
            if (this.delegate != null) {
                this.delegate.onContainerTimeout(this.key, object);
            }
        }
    }
}

