/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.time;

import hellfirepvp.astralsorcery.common.data.config.registry.TileAccelerationBlacklistRegistry;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TimeStopZone {
    final EntityTargetController targetController;
    final float range;
    final BlockPos offset;
    private final World world;
    private int ticksToLive = 0;
    private boolean active = true;
    private List<TileEntity> cachedTiles = new LinkedList<TileEntity>();

    TimeStopZone(EntityTargetController ctrl, float range, BlockPos offset, World world, int tickLivespan) {
        this.targetController = ctrl;
        this.range = range;
        this.offset = offset;
        this.world = world;
        this.ticksToLive = tickLivespan;
    }

    void onServerTick() {
        if (!this.active) {
            return;
        }
        --this.ticksToLive;
        int minX = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177958_n() - this.range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177958_n() + this.range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177952_p() - this.range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177952_p() + this.range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = this.world.func_212866_a_(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry teEntry : map.entrySet()) {
                    TileEntity te = (TileEntity)teEntry.getValue();
                    if (!TileAccelerationBlacklistRegistry.INSTANCE.canBeInfluenced(te) || !te.func_174877_v().func_218141_a((Vec3i)this.offset, (double)this.range) || !this.world.field_175730_i.contains(te)) continue;
                    this.world.field_175730_i.remove(te);
                    this.safeCacheTile(te);
                }
            }
        }
    }

    private void safeCacheTile(TileEntity te) {
        if (te == null) {
            return;
        }
        for (TileEntity tile : this.cachedTiles) {
            if (!tile.func_174877_v().equals((Object)te.func_174877_v())) continue;
            return;
        }
        this.cachedTiles.add(te);
    }

    public void setTicksToLive(int ticksToLive) {
        this.ticksToLive = ticksToLive;
    }

    void stopEffect() {
        for (TileEntity cached : this.cachedTiles) {
            TileEntity te;
            BlockState state = this.world.func_180495_p(cached.func_174877_v());
            if (!state.func_177230_c().hasTileEntity(state) || (te = state.func_177230_c().createTileEntity(state, (IBlockReader)this.world)) == null || !te.getClass().isAssignableFrom(cached.getClass())) continue;
            this.world.field_175730_i.add(cached);
        }
        this.cachedTiles.clear();
        this.active = false;
    }

    boolean shouldDespawn() {
        return this.ticksToLive <= 0 || !this.active;
    }

    boolean interceptEntityTick(LivingEntity e) {
        return this.active && e != null && this.targetController.shouldFreezeEntity(e) && Vector3.atEntityCorner((Entity)e).distance((Vec3i)this.offset) <= (double)this.range;
    }

    static void handleImportantEntityTicks(LivingEntity e) {
        IPhase phase;
        if (e.field_70737_aN > 0) {
            --e.field_70737_aN;
        }
        if (e.field_70172_ad > 0) {
            --e.field_70172_ad;
        }
        e.field_70169_q = e.func_226277_ct_();
        e.field_70167_r = e.func_226278_cu_();
        e.field_70166_s = e.func_226281_cx_();
        e.field_184618_aE = e.field_70721_aZ;
        e.field_70760_ar = e.field_70761_aq;
        e.field_70127_C = e.field_70125_A;
        e.field_70126_B = e.field_70177_z;
        e.field_70758_at = e.field_70759_as;
        e.field_70732_aI = e.field_70733_aJ;
        e.field_70141_P = e.field_70140_Q;
        if (!e.func_130014_f_().func_201670_d()) {
            e.func_213352_e(Vec3d.field_186680_a);
        }
        if (e instanceof EnderDragonEntity && (phase = ((EnderDragonEntity)e).func_184670_cT().func_188756_a()).func_188652_i() != PhaseType.field_188741_a && phase.func_188652_i() != PhaseType.field_188750_j) {
            ((EnderDragonEntity)e).func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        }
    }

    public static class EntityTargetController {
        final int ownerId;
        final boolean hasOwner;
        final boolean targetPlayers;

        EntityTargetController(int ownerId, boolean hasOwner, boolean targetPlayers) {
            this.ownerId = ownerId;
            this.hasOwner = hasOwner;
            this.targetPlayers = targetPlayers;
        }

        boolean shouldFreezeEntity(LivingEntity e) {
            if (!e.func_70089_S() || e.func_110143_aJ() <= 0.0f) {
                return false;
            }
            if (e instanceof EnderDragonEntity && ((EnderDragonEntity)e).func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188750_j) {
                return false;
            }
            if (this.hasOwner && e.func_145782_y() == this.ownerId) {
                return false;
            }
            return this.targetPlayers || !(e instanceof PlayerEntity);
        }

        public static EntityTargetController allExcept(Entity entity) {
            return new EntityTargetController(entity.func_145782_y(), true, true);
        }

        public static EntityTargetController noPlayers() {
            return new EntityTargetController(-1, false, false);
        }

        @Nonnull
        public CompoundNBT serializeNBT() {
            CompoundNBT out = new CompoundNBT();
            out.func_74757_a("targetPlayers", this.targetPlayers);
            out.func_74757_a("hasOwner", this.hasOwner);
            out.func_74768_a("ownerEntityId", this.ownerId);
            return out;
        }

        @Nonnull
        public static EntityTargetController deserializeNBT(CompoundNBT cmp) {
            boolean targetPlayers = cmp.func_74767_n("targetPlayers");
            boolean hasOwner = cmp.func_74767_n("hasOwner");
            int ownerId = cmp.func_74762_e("ownerEntityId");
            return new EntityTargetController(ownerId, hasOwner, targetPlayers);
        }
    }
}

