/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.placement;

import com.mojang.datafixers.Dynamic;
import hellfirepvp.astralsorcery.common.world.config.FeaturePlacementConfig;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;

public class RandomFlowerPlacement
extends Placement<FeaturePlacementConfig> {
    public RandomFlowerPlacement(Function<Dynamic<?>, ? extends FeaturePlacementConfig> cfgSupplier) {
        super(cfgSupplier);
    }

    public RandomFlowerPlacement(FeaturePlacementConfig config) {
        super(dyn -> config);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generatorIn, Random random, FeaturePlacementConfig configIn, BlockPos pos) {
        if (!configIn.canGenerateAtAll() || random.nextInt(Math.max(configIn.getGenerationChance(), 1)) != 0) {
            return Stream.empty();
        }
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int i = 0; i < configIn.getGenerationAmount(); ++i) {
            if (!configIn.generatesInBiome(worldIn.func_226691_t_(pos))) {
                return Stream.empty();
            }
            BlockPos at = pos.func_177982_a(random.nextInt(16), 0, random.nextInt(16));
            at = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, at);
            if (!configIn.canPlace(worldIn, generatorIn.func_202090_b(), at, random)) continue;
            result.add(at);
        }
        return result.stream();
    }
}

