/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure.feature;

import hellfirepvp.astralsorcery.common.world.config.StructurePlacementConfig;
import hellfirepvp.astralsorcery.common.world.placement.StructurePlacement;
import hellfirepvp.astralsorcery.common.world.structure.ConfiguredStructureStart;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class ConfiguredStructureFeature
extends ScatteredStructure<NoFeatureConfig> {
    private final StructurePlacementConfig placementConfig;
    private final StructurePlacement<?> placement;

    public ConfiguredStructureFeature(StructurePlacementConfig placementConfig) {
        super(NoFeatureConfig::func_214639_a);
        this.placementConfig = placementConfig;
        this.placement = this.createPlacement(placementConfig);
    }

    protected StructurePlacement<?> createPlacement(StructurePlacementConfig placementConfig) {
        return new StructurePlacement<StructurePlacementConfig>(dyn -> placementConfig);
    }

    protected Structure.IStartFactory configuredStart(ConfiguredStructureStart.IConfiguredStartFactory factory) {
        return (structure, chunkX, chunkZ, structureBoundingBox, reference, seed) -> {
            ConfiguredStructureStart start = factory.create(structure, chunkX, chunkZ, structureBoundingBox, reference, seed);
            start.setPlacementStrategy(this.placement);
            return start;
        };
    }

    protected int func_202382_c() {
        return 0x5815931A ^ this.func_143025_a().hashCode() * 31;
    }

    protected int func_211745_b(ChunkGenerator<?> chunkGenerator) {
        return this.getPlacementConfig().getStructureSeparation();
    }

    protected int func_204030_a(ChunkGenerator<?> chunkGenerator) {
        return this.getPlacementConfig().getStructureDistance();
    }

    public boolean func_225558_a_(BiomeManager biomeManagerIn, ChunkGenerator<?> chunkGenerator, Random rand, int chunkX, int chunkZ, Biome biomeIn) {
        if (!this.getPlacementConfig().canGenerateAtAll()) {
            return false;
        }
        ChunkPos chunkpos = this.func_211744_a(chunkGenerator, rand, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b) {
            BlockPos at = new BlockPos(chunkX * 16 + 9, 0, chunkZ * 16 + 9);
            int yLevel = chunkGenerator.func_222531_c(at.func_177958_n(), at.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG);
            Biome biome = biomeManagerIn.func_226836_a_(at = new BlockPos(at.func_177958_n(), yLevel, at.func_177952_p()));
            return chunkGenerator.func_202094_a(biome, (Structure)this) && this.getPlacementConfig().canPlace(chunkGenerator.field_222540_a, chunkGenerator.func_202090_b(), at, rand);
        }
        return false;
    }

    public StructurePlacementConfig getPlacementConfig() {
        return this.placementConfig;
    }

    public int func_202367_b() {
        return this.getPlacementConfig().getStructureSize();
    }
}

