/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.data.recipes.altar;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.builder.SimpleAltarRecipeBuilder;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.CrystalIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeTypeHandler;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseItemRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseNBTCopyRecipe;
import hellfirepvp.astralsorcery.common.item.ItemResonator;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.FluidsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.lib.TagsAS;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RadianceAltarRecipeProvider {
    public static void registerAltarRecipes(Consumer<IFinishedRecipe> registrar) {
        RadianceAltarRecipeProvider.registerRecipes(registrar);
        RadianceAltarRecipeProvider.registerConstellationRecipes(registrar);
    }

    private static void registerRecipes(Consumer<IFinishedRecipe> registrar) {
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)ItemsAS.MANTLE, AltarType.RADIANCE).setStarlightRequirement(0.6f).setInputs(AltarRecipeGrid.builder().patternLine("     ").patternLine("R C R").patternLine("RIAIR").patternLine("SI IS").patternLine("S   S").key(Character.valueOf('C'), new CrystalIngredient(false, false)).key(Character.valueOf('A'), (IItemProvider)Items.field_151027_R).key(Character.valueOf('I'), (IItemProvider)ItemsAS.ILLUMINATION_POWDER).key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATING_GEM).key(Character.valueOf('S'), TagsAS.Items.DUSTS_STARDUST)).addRelayInput(TagsAS.Items.INGOTS_STARMETAL).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput((Tag<Item>)Tags.Items.FEATHERS).addRelayInput((Tag<Item>)Tags.Items.ENDER_PEARLS).addOutput((IItemProvider)ItemsAS.MANTLE).build(registrar);
        SimpleAltarRecipeBuilder.ofType(AltarRecipeTypeHandler.NBT_COPY).createRecipe(NameUtil.suffixPath(ItemsAS.RESONATOR.getRegistryName(), "_upgrade_ichosic"), AltarType.RADIANCE).modify(recipe -> recipe.addNBTCopyMatchIngredient(new IItemProvider[]{ItemsAS.RESONATOR})).setFocusConstellation(ConstellationsAS.octans).setStarlightRequirement(0.8f).setInputs(AltarRecipeGrid.builder().patternLine("  I  ").patternLine("S R S").patternLine(" SLS ").patternLine("  S  ").patternLine(" GGG ").key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATOR).key(Character.valueOf('L'), (Fluid)FluidsAS.LIQUID_STARLIGHT_SOURCE).key(Character.valueOf('S'), TagsAS.Items.DUSTS_STARDUST).key(Character.valueOf('I'), (IItemProvider)ItemsAS.ILLUMINATION_POWDER).key(Character.valueOf('G'), (IItemProvider)ItemsAS.RESONATING_GEM)).addOutput(ItemResonator.setCurrentUpgradeUnsafe(ItemResonator.setUpgradeUnlocked(new ItemStack((IItemProvider)ItemsAS.RESONATOR), ItemResonator.ResonatorUpgrade.STARLIGHT, ItemResonator.ResonatorUpgrade.FLUID_FIELDS), ItemResonator.ResonatorUpgrade.FLUID_FIELDS)).build(registrar);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)BlocksAS.FOUNTAIN, AltarType.RADIANCE).setStarlightRequirement(0.5f).setInputs(AltarRecipeGrid.builder().patternLine("WSSSW").patternLine("WMCMW").patternLine("WGRGW").patternLine(" MRM ").patternLine("     ").key(Character.valueOf('C'), new CrystalIngredient(false, false)).key(Character.valueOf('G'), (Tag<Item>)Tags.Items.INGOTS_GOLD).key(Character.valueOf('W'), (IItemProvider)BlocksAS.INFUSED_WOOD_PLANKS).key(Character.valueOf('S'), (IItemProvider)BlocksAS.BLACK_MARBLE_RAW).key(Character.valueOf('M'), TagsAS.Items.INGOTS_STARMETAL).key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATING_GEM)).addOutput((IItemProvider)BlocksAS.FOUNTAIN).addRelayInput(TagsAS.Items.FORGE_GEM_AQUAMARINE).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput(TagsAS.Items.FORGE_GEM_AQUAMARINE).addRelayInput(TagsAS.Items.DUSTS_STARDUST).build(registrar);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)BlocksAS.FOUNTAIN_PRIME_LIQUID, AltarType.RADIANCE).setStarlightRequirement(0.7f).setFocusConstellation(ConstellationsAS.octans).setInputs(AltarRecipeGrid.builder().patternLine("GSSSG").patternLine("RG GR").patternLine(" MLM ").patternLine(" R R ").patternLine(" RLR ").key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATING_GEM).key(Character.valueOf('G'), (Tag<Item>)Tags.Items.INGOTS_GOLD).key(Character.valueOf('M'), TagsAS.Items.INGOTS_STARMETAL).key(Character.valueOf('L'), (IItemProvider)ItemsAS.GLASS_LENS).key(Character.valueOf('S'), (IItemProvider)BlocksAS.BLACK_MARBLE_RAW)).addOutput((IItemProvider)BlocksAS.FOUNTAIN_PRIME_LIQUID).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput(TagsAS.Items.DUSTS_STARDUST).build(registrar);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)BlocksAS.FOUNTAIN_PRIME_VORTEX, AltarType.RADIANCE).setStarlightRequirement(0.7f).setFocusConstellation(ConstellationsAS.vicio).setInputs(AltarRecipeGrid.builder().patternLine("GSSSG").patternLine(" GRG ").patternLine("M L M").patternLine("M   M").patternLine(" M M ").key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATING_GEM).key(Character.valueOf('G'), (Tag<Item>)Tags.Items.INGOTS_GOLD).key(Character.valueOf('M'), TagsAS.Items.INGOTS_STARMETAL).key(Character.valueOf('L'), (IItemProvider)ItemsAS.GLASS_LENS).key(Character.valueOf('S'), (IItemProvider)BlocksAS.BLACK_MARBLE_RAW)).addOutput((IItemProvider)BlocksAS.FOUNTAIN_PRIME_VORTEX).addRelayInput((IItemProvider)ItemsAS.NOCTURNAL_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput((IItemProvider)ItemsAS.NOCTURNAL_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).build(registrar);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)BlocksAS.CHALICE, AltarType.RADIANCE).setStarlightRequirement(0.5f).setInputs(AltarRecipeGrid.builder().patternLine("     ").patternLine("R   R").patternLine("RGSGR").patternLine(" MSM ").patternLine(" GSG ").key(Character.valueOf('R'), (IItemProvider)ItemsAS.RESONATING_GEM).key(Character.valueOf('G'), (Tag<Item>)Tags.Items.INGOTS_GOLD).key(Character.valueOf('S'), (IItemProvider)BlocksAS.BLACK_MARBLE_RAW).key(Character.valueOf('M'), TagsAS.Items.INGOTS_STARMETAL)).addOutput((IItemProvider)BlocksAS.CHALICE).addRelayInput((IItemProvider)ItemsAS.AQUAMARINE).addRelayInput((IItemProvider)ItemsAS.AQUAMARINE).addRelayInput((IItemProvider)ItemsAS.AQUAMARINE).addRelayInput((IItemProvider)ItemsAS.AQUAMARINE).addRelayInput((IItemProvider)ItemsAS.AQUAMARINE).build(registrar);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)BlocksAS.OBSERVATORY, AltarType.RADIANCE).setFocusConstellation(ConstellationsAS.lucerna).setStarlightRequirement(0.4f).setInputs(AltarRecipeGrid.builder().patternLine("  NRL").patternLine(" NRIR").patternLine("NRLRN").patternLine("G RN ").patternLine("GGG  ").key(Character.valueOf('N'), (Tag<Item>)Tags.Items.NUGGETS_GOLD).key(Character.valueOf('I'), (IItemProvider)ItemsAS.INFUSED_GLASS).key(Character.valueOf('G'), (Tag<Item>)Tags.Items.INGOTS_GOLD).key(Character.valueOf('R'), (IItemProvider)BlocksAS.MARBLE_RUNED).key(Character.valueOf('L'), (IItemProvider)ItemsAS.GLASS_LENS)).addOutput((IItemProvider)BlocksAS.OBSERVATORY).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput((IItemProvider)ItemsAS.NOCTURNAL_POWDER).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput((IItemProvider)ItemsAS.NOCTURNAL_POWDER).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).build(registrar);
        RadianceAltarRecipeProvider.registerShiftingStarRecipe(registrar, ConstellationsAS.aevitas, ItemsAS.SHIFTING_STAR_AEVITAS);
        RadianceAltarRecipeProvider.registerShiftingStarRecipe(registrar, ConstellationsAS.armara, ItemsAS.SHIFTING_STAR_ARMARA);
        RadianceAltarRecipeProvider.registerShiftingStarRecipe(registrar, ConstellationsAS.discidia, ItemsAS.SHIFTING_STAR_DISCIDIA);
        RadianceAltarRecipeProvider.registerShiftingStarRecipe(registrar, ConstellationsAS.evorsio, ItemsAS.SHIFTING_STAR_EVORSIO);
        RadianceAltarRecipeProvider.registerShiftingStarRecipe(registrar, ConstellationsAS.vicio, ItemsAS.SHIFTING_STAR_VICIO);
    }

    private static void registerShiftingStarRecipe(Consumer<IFinishedRecipe> registrar, IMajorConstellation constellation, Item shiftingStarItem) {
        Ingredient signature = constellation.getConstellationSignatureItems().get(0);
        SimpleAltarRecipeBuilder.builder().createRecipe((ForgeRegistryEntry<?>)shiftingStarItem, AltarType.RADIANCE).setFocusConstellation(constellation).setStarlightRequirement(0.6f).setInputs(AltarRecipeGrid.builder().patternLine("  S  ").patternLine("  C  ").patternLine("SIBIS").patternLine("  C  ").patternLine("  S  ").key(Character.valueOf('B'), (IItemProvider)ItemsAS.SHIFTING_STAR).key(Character.valueOf('I'), TagsAS.Items.INGOTS_STARMETAL).key(Character.valueOf('S'), TagsAS.Items.DUSTS_STARDUST).key(Character.valueOf('C'), signature)).addOutput((IItemProvider)shiftingStarItem).addRelayInput(signature).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).addRelayInput(signature).addRelayInput((IItemProvider)ItemsAS.ILLUMINATION_POWDER).addRelayInput(TagsAS.Items.DUSTS_STARDUST).build(registrar);
    }

    private static void registerConstellationRecipes(Consumer<IFinishedRecipe> registrar) {
        RegistriesAS.REGISTRY_CONSTELLATIONS.forEach(cst -> {
            if (Mods.ASTRAL_SORCERY.owns((IForgeRegistryEntry<?>)cst)) {
                RadianceAltarRecipeProvider.registerConstellationPaperRecipe(registrar, cst);
                if (cst instanceof IWeakConstellation) {
                    RadianceAltarRecipeProvider.registerMantleRecipe(registrar, (IWeakConstellation)cst);
                }
            }
        });
    }

    private static void registerMantleRecipe(Consumer<IFinishedRecipe> registrar, IWeakConstellation constellation) {
        List<Ingredient> signature = constellation.getConstellationSignatureItems();
        if (signature.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a mantle recipe for constellation without signature items: " + constellation.getRegistryName());
        }
        Ingredient center = signature.get(0);
        SimpleAltarRecipeBuilder<ConstellationBaseNBTCopyRecipe> builder = SimpleAltarRecipeBuilder.ofType(AltarRecipeTypeHandler.CONSTELLATION_BASE_NBT_COPY).createRecipe(AstralSorcery.key("mantle_" + constellation.getSimpleName()), AltarType.RADIANCE).modify(recipe -> recipe.setConstellation(constellation).addNBTCopyMatchIngredient(new IItemProvider[]{ItemsAS.MANTLE})).setFocusConstellation(constellation).multiplyDuration(1.2f).setStarlightRequirement(0.8f).setInputs(AltarRecipeGrid.builder().patternLine("  S  ").patternLine("  L  ").patternLine("SLMLS").patternLine("  L  ").patternLine("  S  ").key(Character.valueOf('L'), center).key(Character.valueOf('M'), (IItemProvider)ItemsAS.MANTLE).key(Character.valueOf('S'), TagsAS.Items.DUSTS_STARDUST)).addOutput((IItemProvider)ItemsAS.MANTLE);
        signature.forEach(builder::addRelayInput);
        builder.build(registrar);
    }

    private static void registerConstellationPaperRecipe(Consumer<IFinishedRecipe> registrar, IConstellation constellation) {
        List<Ingredient> signature = constellation.getConstellationSignatureItems();
        if (signature.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a constellation paper recipe for constellation without signature items: " + constellation.getRegistryName());
        }
        Ingredient center = signature.get(0);
        SimpleAltarRecipeBuilder<ConstellationBaseItemRecipe> builder = SimpleAltarRecipeBuilder.ofType(AltarRecipeTypeHandler.CONSTELLATION_ITEM_BASE).createRecipe(AstralSorcery.key("constellation_paper_" + constellation.getSimpleName()), AltarType.RADIANCE).modify(recipe -> recipe.setConstellation(constellation)).multiplyDuration(0.7f).setStarlightRequirement(0.4f).setInputs(AltarRecipeGrid.builder().patternLine("  L  ").patternLine("  F  ").patternLine("LSPSL").patternLine("  B  ").patternLine("  L  ").key(Character.valueOf('L'), center).key(Character.valueOf('B'), (Tag<Item>)Tags.Items.DYES_BLACK).key(Character.valueOf('P'), (IItemProvider)ItemsAS.PARCHMENT).key(Character.valueOf('F'), (Tag<Item>)Tags.Items.FEATHERS).key(Character.valueOf('S'), TagsAS.Items.DUSTS_STARDUST)).addOutput((IItemProvider)ItemsAS.CONSTELLATION_PAPER);
        signature.forEach(builder::addRelayInput);
        builder.build(registrar);
    }
}

