/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.logging.log4j.LogManager;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FilterGhostIngredientHandler<T extends AbstractFilterContainer>
implements IGhostIngredientHandler<AbstractFilterScreen<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AbstractFilterScreen<T> gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        boolean isAttributeFilter = gui instanceof AttributeFilterScreen;
        if (ingredient instanceof ItemStack) {
            for (int i = 36; i < ((AbstractFilterContainer)gui.func_212873_a_()).field_75151_b.size(); ++i) {
                targets.add(new FilterGhostTarget(gui, i - 36, isAttributeFilter));
                if (isAttributeFilter) break;
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    private static class FilterGhostTarget<I, T extends AbstractFilterContainer>
    implements IGhostIngredientHandler.Target<I> {
        private final Rectangle2d area;
        private final AbstractFilterScreen<T> gui;
        private final int slotIndex;
        private final boolean isAttributeFilter;

        public FilterGhostTarget(AbstractFilterScreen<T> gui, int slotIndex, boolean isAttributeFilter) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            this.isAttributeFilter = isAttributeFilter;
            Slot slot = (Slot)((AbstractFilterContainer)gui.func_212873_a_()).field_75151_b.get(slotIndex + 36);
            this.area = new Rectangle2d(gui.getGuiLeft() + slot.field_75223_e, gui.getGuiTop() + slot.field_75221_f, 16, 16);
        }

        public Rectangle2d getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).func_77946_l();
            LogManager.getLogger().info((Object)stack);
            stack.func_190920_e(1);
            ((AbstractFilterContainer)this.gui.func_212873_a_()).filterInventory.setStackInSlot(this.slotIndex, stack);
            if (this.isAttributeFilter) {
                return;
            }
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a("Slot", this.slotIndex);
            data.func_218657_a("Item", (INBT)stack.serializeNBT());
            AllPackets.channel.sendToServer((Object)new FilterScreenPacket(FilterScreenPacket.Option.UPDATE_FILTER_ITEM, data));
        }
    }
}

