/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedCrushingWheels;
import com.simibubi.create.content.contraptions.components.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class CrushingCategory
extends CreateRecipeCategory<AbstractCrushingRecipe> {
    private AnimatedCrushingWheels crushingWheels = new AnimatedCrushingWheels();

    public CrushingCategory() {
        super(CrushingCategory.doubleItemIcon((IItemProvider)AllBlocks.CRUSHING_WHEEL.get(), (IItemProvider)AllItems.CRUSHED_GOLD.get()), CrushingCategory.emptyBackground(177, 100));
    }

    public Class<? extends AbstractCrushingRecipe> getRecipeClass() {
        return AbstractCrushingRecipe.class;
    }

    public void setIngredients(AbstractCrushingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getRollableResultsAsItemStacks());
    }

    public void setRecipe(IRecipeLayout recipeLayout, AbstractCrushingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 50, 2);
        itemStacks.set(0, Arrays.asList(((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()));
        NonNullList<ProcessingOutput> results = recipe.getRollableResults();
        int size = results.size();
        int offset = -size * 19 / 2;
        for (int outputIndex = 0; outputIndex < size; ++outputIndex) {
            itemStacks.init(outputIndex + 1, false, this.getBackground().getWidth() / 2 + offset + 19 * outputIndex, 78);
            itemStacks.set(outputIndex + 1, ((ProcessingOutput)results.get(outputIndex)).getStack());
        }
        CrushingCategory.addStochasticTooltip(itemStacks, results);
    }

    public void draw(AbstractCrushingRecipe recipe, double mouseX, double mouseY) {
        NonNullList<ProcessingOutput> results = recipe.getRollableResults();
        AllGuiTextures.JEI_SLOT.draw(50, 2);
        AllGuiTextures.JEI_DOWN_ARROW.draw(72, 7);
        int size = results.size();
        int offset = -size * 19 / 2;
        for (int outputIndex = 0; outputIndex < results.size(); ++outputIndex) {
            CrushingCategory.getRenderedSlot(recipe, outputIndex).draw(this.getBackground().getWidth() / 2 + offset + 19 * outputIndex, 78);
        }
        this.crushingWheels.draw(62, 59);
    }
}

