/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedCrafter;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class MechanicalCraftingCategory
extends CreateRecipeCategory<ICraftingRecipe> {
    private final AnimatedCrafter crafter = new AnimatedCrafter();
    static int maxSize = 100;

    public MechanicalCraftingCategory() {
        super(MechanicalCraftingCategory.itemIcon((IItemProvider)AllBlocks.MECHANICAL_CRAFTER.get()), MechanicalCraftingCategory.emptyBackground(177, 107));
    }

    public void setIngredients(ICraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ICraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList recipeIngredients = recipe.func_192400_c();
        itemStacks.init(0, false, 133, 80);
        itemStacks.set(0, recipe.func_77571_b().getStack());
        int x = MechanicalCraftingCategory.getXPadding(recipe);
        int y = MechanicalCraftingCategory.getYPadding(recipe);
        float scale = MechanicalCraftingCategory.getScale(recipe);
        int size = recipeIngredients.size();
        CrafterIngredientRenderer renderer = new CrafterIngredientRenderer(recipe);
        for (int i = 0; i < size; ++i) {
            float f = 19.0f * scale;
            int slotSize = (int)(16.0f * scale);
            int xPosition = (int)((float)(x + 1) + (float)(i % MechanicalCraftingCategory.getWidth(recipe)) * f);
            int yPosition = (int)((float)(y + 1) + (float)(i / MechanicalCraftingCategory.getWidth(recipe)) * f);
            itemStacks.init(i + 1, true, (IIngredientRenderer)renderer, xPosition, yPosition, slotSize, slotSize, 0, 0);
            itemStacks.set(i + 1, Arrays.asList(((Ingredient)recipeIngredients.get(i)).func_193365_a()));
        }
    }

    public static float getScale(ICraftingRecipe recipe) {
        int w = MechanicalCraftingCategory.getWidth(recipe);
        int h = MechanicalCraftingCategory.getHeight(recipe);
        return Math.min(1.0f, (float)maxSize / (19.0f * (float)Math.max(w, h)));
    }

    public static int getYPadding(ICraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getHeight(recipe) * 19.0f) * 0.5);
    }

    public static int getXPadding(ICraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getWidth(recipe) * 19.0f) * 0.5);
    }

    private static int getWidth(ICraftingRecipe recipe) {
        return recipe instanceof ShapedRecipe ? ((ShapedRecipe)recipe).func_192403_f() : 1;
    }

    private static int getHeight(ICraftingRecipe recipe) {
        return recipe instanceof ShapedRecipe ? ((ShapedRecipe)recipe).func_192404_g() : 1;
    }

    public void draw(ICraftingRecipe recipe, double mouseX, double mouseY) {
        RenderSystem.pushMatrix();
        float scale = MechanicalCraftingCategory.getScale(recipe);
        RenderSystem.translated((double)MechanicalCraftingCategory.getXPadding(recipe), (double)MechanicalCraftingCategory.getYPadding(recipe), (double)0.0);
        for (int row = 0; row < MechanicalCraftingCategory.getHeight(recipe); ++row) {
            for (int col = 0; col < MechanicalCraftingCategory.getWidth(recipe); ++col) {
                if (((Ingredient)recipe.func_192400_c().get(row * MechanicalCraftingCategory.getWidth(recipe) + col)).func_203189_d()) continue;
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)((float)(col * 19) * scale), (double)((float)(row * 19) * scale), (double)0.0);
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                AllGuiTextures.JEI_SLOT.draw(0, 0);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.popMatrix();
        AllGuiTextures.JEI_SLOT.draw(133, 80);
        AllGuiTextures.JEI_DOWN_ARROW.draw(128, 59);
        this.crafter.draw(129, 25);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)300.0);
        RenderHelper.func_74518_a();
        int amount = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            if (Ingredient.field_193370_a == ingredient) continue;
            ++amount;
        }
        Minecraft.func_71410_x().field_71466_p.func_175063_a(amount + "", 142.0f, 39.0f, 0xFFFFFF);
        RenderSystem.popMatrix();
    }

    public Class<? extends ICraftingRecipe> getRecipeClass() {
        return ICraftingRecipe.class;
    }

    private static final class CrafterIngredientRenderer
    implements IIngredientRenderer<ItemStack> {
        private final ICraftingRecipe recipe;

        public CrafterIngredientRenderer(ICraftingRecipe recipe) {
            this.recipe = recipe;
        }

        public void render(int xPosition, int yPosition, ItemStack ingredient) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)xPosition, (double)yPosition, (double)0.0);
            float scale = MechanicalCraftingCategory.getScale(this.recipe);
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            if (ingredient != null) {
                RenderSystem.enableDepthTest();
                RenderHelper.func_227780_a_();
                Minecraft minecraft = Minecraft.func_71410_x();
                FontRenderer font = this.getFontRenderer(minecraft, ingredient);
                ItemRenderer itemRenderer = minecraft.func_175599_af();
                itemRenderer.func_184391_a(null, ingredient, 0, 0);
                itemRenderer.func_180453_a(font, ingredient, 0, 0, null);
                RenderSystem.disableBlend();
                RenderHelper.func_74518_a();
            }
            RenderSystem.popMatrix();
        }

        public List<String> getTooltip(ItemStack ingredient, ITooltipFlag tooltipFlag) {
            Rarity rarity;
            List<String> list;
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            try {
                list = ingredient.func_82840_a((PlayerEntity)player, tooltipFlag).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
            }
            catch (LinkageError | RuntimeException e) {
                return new ArrayList<String>();
            }
            try {
                rarity = ingredient.func_77953_t();
            }
            catch (LinkageError | RuntimeException e) {
                rarity = Rarity.COMMON;
            }
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, rarity.field_77937_e + list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY + list.get(k));
            }
            return list;
        }
    }
}

