/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.encased.DirectionalShaftHalvesTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.EncasedBeltBlock;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RotationPropagator {
    private static final int MAX_FLICKER_SCORE = 128;

    private static float getRotationSpeedModifier(KineticTileEntity from, KineticTileEntity to) {
        boolean connectedByGears;
        BlockState stateFrom = from.func_195044_w();
        BlockState stateTo = to.func_195044_w();
        Block fromBlock = stateFrom.func_177230_c();
        Block toBlock = stateTo.func_177230_c();
        if (!(fromBlock instanceof IRotate) || !(toBlock instanceof IRotate)) {
            return 0.0f;
        }
        IRotate definitionFrom = (IRotate)fromBlock;
        IRotate definitionTo = (IRotate)toBlock;
        BlockPos diff = to.func_174877_v().func_177973_b((Vec3i)from.func_174877_v());
        Direction direction = Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
        World world = from.func_145831_w();
        boolean alignedAxes = true;
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == direction.func_176740_k() || axis.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p()) == 0) continue;
            alignedAxes = false;
        }
        boolean connectedByAxis = alignedAxes && definitionFrom.hasShaftTowards((IWorldReader)world, from.func_174877_v(), stateFrom, direction) && definitionTo.hasShaftTowards((IWorldReader)world, to.func_174877_v(), stateTo, direction.func_176734_d());
        boolean bl = connectedByGears = definitionFrom.hasIntegratedCogwheel((IWorldReader)world, from.func_174877_v(), stateFrom) && definitionTo.hasIntegratedCogwheel((IWorldReader)world, to.func_174877_v(), stateTo);
        if (from instanceof BeltTileEntity && to instanceof BeltTileEntity && !connectedByAxis) {
            return ((BeltTileEntity)from).getController().equals((Object)((BeltTileEntity)to).getController()) ? 1.0f : 0.0f;
        }
        if (connectedByAxis) {
            float axisModifier = RotationPropagator.getAxisModifier(to, direction.func_176734_d());
            if (axisModifier != 0.0f) {
                axisModifier = 1.0f / axisModifier;
            }
            return RotationPropagator.getAxisModifier(from, direction) * axisModifier;
        }
        if (fromBlock instanceof EncasedBeltBlock && toBlock instanceof EncasedBeltBlock) {
            boolean connected = EncasedBeltBlock.areBlocksConnected(stateFrom, stateTo, direction);
            return connected ? EncasedBeltBlock.getRotationSpeedModifier(from, to) : 0.0f;
        }
        if (RotationPropagator.isLargeToLargeGear(stateFrom, stateTo, diff)) {
            Direction.Axis sourceAxis = (Direction.Axis)stateFrom.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
            Direction.Axis targetAxis = (Direction.Axis)stateTo.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
            int sourceAxisDiff = sourceAxis.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p());
            int targetAxisDiff = targetAxis.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p());
            return sourceAxisDiff > 0 ^ targetAxisDiff > 0 ? -1.0f : 1.0f;
        }
        if (CogWheelBlock.isLargeCog(stateFrom) && definitionTo.hasIntegratedCogwheel((IWorldReader)world, to.func_174877_v(), stateTo) && RotationPropagator.isLargeToSmallCog(stateFrom, stateTo, definitionTo, diff)) {
            return -2.0f;
        }
        if (CogWheelBlock.isLargeCog(stateTo) && definitionFrom.hasIntegratedCogwheel((IWorldReader)world, from.func_174877_v(), stateFrom) && RotationPropagator.isLargeToSmallCog(stateTo, stateFrom, definitionFrom, diff)) {
            return -0.5f;
        }
        if (connectedByGears) {
            if (diff.func_218139_n((Vec3i)BlockPos.field_177992_a) != 1) {
                return 0.0f;
            }
            if (CogWheelBlock.isLargeCog(stateTo)) {
                return 0.0f;
            }
            if (direction.func_176740_k() == definitionFrom.getRotationAxis(stateFrom)) {
                return 0.0f;
            }
            if (definitionFrom.getRotationAxis(stateFrom) == definitionTo.getRotationAxis(stateTo)) {
                return -1.0f;
            }
        }
        return 0.0f;
    }

    private static float getConveyedSpeed(KineticTileEntity from, KineticTileEntity to) {
        BlockState stateTo;
        BlockState stateFrom = from.func_195044_w();
        if (RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.func_195044_w(), to.func_174877_v().func_177973_b((Vec3i)from.func_174877_v()))) {
            return SpeedControllerTileEntity.getConveyedSpeed(from, to, true);
        }
        if (RotationPropagator.isLargeCogToSpeedController(stateTo, stateFrom, from.func_174877_v().func_177973_b((Vec3i)to.func_174877_v()))) {
            return SpeedControllerTileEntity.getConveyedSpeed(to, from, false);
        }
        float rotationSpeedModifier = RotationPropagator.getRotationSpeedModifier(from, to);
        return from.getTheoreticalSpeed() * rotationSpeedModifier;
    }

    private static boolean isLargeToLargeGear(BlockState from, BlockState to, BlockPos diff) {
        Direction.Axis toAxis;
        if (!CogWheelBlock.isLargeCog(from) || !CogWheelBlock.isLargeCog(to)) {
            return false;
        }
        Direction.Axis fromAxis = (Direction.Axis)from.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        if (fromAxis == (toAxis = (Direction.Axis)to.func_177229_b((IProperty)BlockStateProperties.field_208148_A))) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            int axisDiff = axis.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p());
            if (!(axis == fromAxis || axis == toAxis ? axisDiff == 0 : axisDiff != 0)) continue;
            return false;
        }
        return true;
    }

    private static float getAxisModifier(KineticTileEntity te, Direction direction) {
        if (!te.hasSource() || !(te instanceof DirectionalShaftHalvesTileEntity)) {
            return 1.0f;
        }
        Direction source = ((DirectionalShaftHalvesTileEntity)te).getSourceFacing();
        if (te instanceof GearboxTileEntity) {
            return direction.func_176740_k() == source.func_176740_k() ? (direction == source ? 1.0f : -1.0f) : (direction.func_176743_c() == source.func_176743_c() ? -1.0f : 1.0f);
        }
        if (te instanceof SplitShaftTileEntity) {
            return ((SplitShaftTileEntity)te).getRotationSpeedModifier(direction);
        }
        return 1.0f;
    }

    private static boolean isLargeToSmallCog(BlockState from, BlockState to, IRotate defTo, BlockPos diff) {
        Direction.Axis axisFrom = (Direction.Axis)from.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        if (axisFrom != defTo.getRotationAxis(to)) {
            return false;
        }
        if (axisFrom.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p()) != 0) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == axisFrom || Math.abs(axis.func_196052_a(diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p())) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargeCogToSpeedController(BlockState from, BlockState to, BlockPos diff) {
        if (!CogWheelBlock.isLargeCog(from) || !AllBlocks.ROTATION_SPEED_CONTROLLER.has(to)) {
            return false;
        }
        if (!diff.equals((Object)BlockPos.field_177992_a.func_177977_b())) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)from.func_177229_b((IProperty)CogWheelBlock.AXIS);
        if (axis.func_200128_b()) {
            return false;
        }
        return to.func_177229_b(SpeedControllerBlock.HORIZONTAL_AXIS) != axis;
    }

    public static void handleAdded(World worldIn, BlockPos pos, KineticTileEntity addedTE) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!worldIn.func_195588_v(pos)) {
            return;
        }
        RotationPropagator.propagateNewSource(addedTE);
    }

    private static void propagateNewSource(KineticTileEntity currentTE) {
        BlockPos pos = currentTE.func_174877_v();
        World world = currentTE.func_145831_w();
        for (KineticTileEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
            float prevSpeed;
            boolean speedChangedTooOften;
            float speedOfCurrent = currentTE.getTheoreticalSpeed();
            float speedOfNeighbour = neighbourTE.getTheoreticalSpeed();
            float newSpeed = RotationPropagator.getConveyedSpeed(currentTE, neighbourTE);
            float oppositeSpeed = RotationPropagator.getConveyedSpeed(neighbourTE, currentTE);
            boolean incompatible = Math.signum(newSpeed) != Math.signum(speedOfNeighbour) && newSpeed != 0.0f && speedOfNeighbour != 0.0f;
            boolean tooFast = Math.abs(newSpeed) > (float)((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).intValue();
            boolean bl = speedChangedTooOften = currentTE.getFlickerScore() > 128;
            if (tooFast || speedChangedTooOften) {
                world.func_175655_b(pos, true);
                return;
            }
            if (incompatible) {
                world.func_175655_b(pos, true);
                return;
            }
            if (Math.abs(oppositeSpeed) > Math.abs(speedOfCurrent)) {
                prevSpeed = currentTE.getSpeed();
                currentTE.setSource(neighbourTE.func_174877_v());
                currentTE.setSpeed(RotationPropagator.getConveyedSpeed(neighbourTE, currentTE));
                currentTE.onSpeedChanged(prevSpeed);
                currentTE.sendData();
                RotationPropagator.propagateNewSource(currentTE);
                return;
            }
            if (Math.abs(newSpeed) >= Math.abs(speedOfNeighbour)) {
                if (!currentTE.hasNetwork() || currentTE.network.equals(neighbourTE.network)) {
                    float epsilon = Math.abs(speedOfNeighbour) / 256.0f / 256.0f;
                    if (!(Math.abs(newSpeed) > Math.abs(speedOfNeighbour) + epsilon)) continue;
                    world.func_175655_b(pos, true);
                    continue;
                }
                if (currentTE.hasSource() && currentTE.source.equals((Object)neighbourTE.func_174877_v())) {
                    currentTE.removeSource();
                }
                prevSpeed = neighbourTE.getSpeed();
                neighbourTE.setSource(currentTE.func_174877_v());
                neighbourTE.setSpeed(RotationPropagator.getConveyedSpeed(currentTE, neighbourTE));
                neighbourTE.onSpeedChanged(prevSpeed);
                neighbourTE.sendData();
                RotationPropagator.propagateNewSource(neighbourTE);
                continue;
            }
            if (neighbourTE.getTheoreticalSpeed() == newSpeed) continue;
            prevSpeed = neighbourTE.getSpeed();
            neighbourTE.setSpeed(newSpeed);
            neighbourTE.setSource(currentTE.func_174877_v());
            neighbourTE.onSpeedChanged(prevSpeed);
            neighbourTE.sendData();
            RotationPropagator.propagateNewSource(neighbourTE);
        }
    }

    public static void handleRemoved(World worldIn, BlockPos pos, KineticTileEntity removedTE) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (removedTE == null) {
            return;
        }
        if (removedTE.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        for (BlockPos neighbourPos : RotationPropagator.getPotentialNeighbourLocations(removedTE)) {
            KineticTileEntity neighbourTE;
            TileEntity tileEntity;
            BlockState neighbourState = worldIn.func_180495_p(neighbourPos);
            if (!(neighbourState.func_177230_c() instanceof IRotate) || !((tileEntity = worldIn.func_175625_s(neighbourPos)) instanceof KineticTileEntity) || !(neighbourTE = (KineticTileEntity)tileEntity).hasSource() || !neighbourTE.source.equals((Object)pos)) continue;
            RotationPropagator.propagateMissingSource(neighbourTE);
        }
    }

    private static void propagateMissingSource(KineticTileEntity updateTE) {
        BlockPos missingSource;
        World world = updateTE.func_145831_w();
        LinkedList<KineticTileEntity> potentialNewSources = new LinkedList<KineticTileEntity>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(updateTE.func_174877_v());
        BlockPos blockPos = missingSource = updateTE.hasSource() ? updateTE.source : null;
        while (!frontier.isEmpty()) {
            BlockPos pos = (BlockPos)frontier.remove(0);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof KineticTileEntity)) continue;
            KineticTileEntity currentTE = (KineticTileEntity)tileEntity;
            currentTE.removeSource();
            currentTE.sendData();
            for (KineticTileEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
                if (neighbourTE.func_174877_v().equals((Object)missingSource) || !neighbourTE.hasSource()) continue;
                if (!neighbourTE.source.equals((Object)pos)) {
                    potentialNewSources.add(neighbourTE);
                    continue;
                }
                if (neighbourTE.isSource()) {
                    potentialNewSources.add(neighbourTE);
                }
                frontier.add(neighbourTE.func_174877_v());
            }
        }
        for (KineticTileEntity newSource : potentialNewSources) {
            if (!newSource.hasSource() && !newSource.isSource()) continue;
            RotationPropagator.propagateNewSource(newSource);
            return;
        }
    }

    private static KineticTileEntity findConnectedNeighbour(KineticTileEntity currentTE, BlockPos neighbourPos) {
        BlockState neighbourState = currentTE.func_145831_w().func_180495_p(neighbourPos);
        if (!(neighbourState.func_177230_c() instanceof IRotate)) {
            return null;
        }
        if (!neighbourState.hasTileEntity()) {
            return null;
        }
        TileEntity neighbourTE = currentTE.func_145831_w().func_175625_s(neighbourPos);
        if (!(neighbourTE instanceof KineticTileEntity)) {
            return null;
        }
        KineticTileEntity neighbourKTE = (KineticTileEntity)neighbourTE;
        if (!(neighbourKTE.func_195044_w().func_177230_c() instanceof IRotate)) {
            return null;
        }
        if (!RotationPropagator.isConnected(currentTE, neighbourKTE)) {
            return null;
        }
        return neighbourKTE;
    }

    public static boolean isConnected(KineticTileEntity from, KineticTileEntity to) {
        BlockState stateTo;
        BlockState stateFrom = from.func_195044_w();
        if (RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.func_195044_w(), to.func_174877_v().func_177973_b((Vec3i)from.func_174877_v()))) {
            return true;
        }
        if (RotationPropagator.isLargeCogToSpeedController(stateTo, stateFrom, from.func_174877_v().func_177973_b((Vec3i)to.func_174877_v()))) {
            return true;
        }
        return RotationPropagator.getRotationSpeedModifier(from, to) != 0.0f;
    }

    private static List<KineticTileEntity> getConnectedNeighbours(KineticTileEntity te) {
        LinkedList<KineticTileEntity> neighbours = new LinkedList<KineticTileEntity>();
        for (BlockPos neighbourPos : RotationPropagator.getPotentialNeighbourLocations(te)) {
            KineticTileEntity neighbourTE = RotationPropagator.findConnectedNeighbour(te, neighbourPos);
            if (neighbourTE == null) continue;
            neighbours.add(neighbourTE);
        }
        return neighbours;
    }

    private static List<BlockPos> getPotentialNeighbourLocations(KineticTileEntity te) {
        LinkedList<BlockPos> neighbours = new LinkedList<BlockPos>();
        if (!te.func_145831_w().isAreaLoaded(te.func_174877_v(), 1)) {
            return neighbours;
        }
        for (Direction facing : Iterate.directions) {
            neighbours.add(te.func_174877_v().func_177972_a(facing));
        }
        BlockState blockState = te.func_195044_w();
        boolean isLargeWheel = CogWheelBlock.isLargeCog(blockState);
        if (!(blockState.func_177230_c() instanceof IRotate)) {
            return neighbours;
        }
        IRotate block = (IRotate)blockState.func_177230_c();
        if (block.hasIntegratedCogwheel((IWorldReader)te.func_145831_w(), te.func_174877_v(), blockState) || isLargeWheel || AllBlocks.BELT.has(blockState)) {
            Direction.Axis axis = block.getRotationAxis(blockState);
            BlockPos.func_218281_b((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
                if (!isLargeWheel && axis.func_196052_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()) != 0) {
                    return;
                }
                if (offset.func_218140_a(0.0, 0.0, 0.0, false) != BlockPos.field_177992_a.func_218140_a(1.0, 1.0, 0.0, false)) {
                    return;
                }
                neighbours.add(te.func_174877_v().func_177971_a((Vec3i)offset));
            });
        }
        return neighbours;
    }
}

