/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(IWorldReader var1, BlockPos var2, BlockState var3, Direction var4);

    public boolean hasIntegratedCogwheel(IWorldReader var1, BlockPos var2, BlockState var3);

    public Direction.Axis getRotationAxis(BlockState var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum StressImpact {
        LOW,
        MEDIUM,
        HIGH,
        OVERSTRESSED;


        public TextFormatting getAbsoluteColor() {
            return this == LOW ? TextFormatting.YELLOW : (this == MEDIUM ? TextFormatting.GOLD : TextFormatting.RED);
        }

        public TextFormatting getRelativeColor() {
            return this == LOW ? TextFormatting.GREEN : (this == MEDIUM ? TextFormatting.YELLOW : (this == HIGH ? TextFormatting.GOLD : TextFormatting.RED));
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.SERVER.kinetics.disableStress.get() == false;
        }

        public static String getFormattedStressText(double stressPercent) {
            StressImpact stressLevel = StressImpact.of(stressPercent);
            TextFormatting color = stressLevel.getRelativeColor();
            String level = color + ItemDescription.makeProgressBar(3, Math.min(stressLevel.ordinal(), 2));
            level = level + Lang.translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]);
            level = level + String.format(" (%s%%) ", (int)(stressPercent * 100.0));
            return level;
        }
    }

    public static enum SpeedLevel {
        NONE,
        MEDIUM,
        FAST;


        public TextFormatting getTextColor() {
            return this == NONE ? TextFormatting.GREEN : (this == MEDIUM ? TextFormatting.AQUA : TextFormatting.LIGHT_PURPLE);
        }

        public int getColor() {
            return this == NONE ? 0x22FF22 : (this == MEDIUM ? 34047 : 0xFF55FF);
        }

        public int getParticleSpeed() {
            return this == NONE ? 10 : (this == MEDIUM ? 20 : 30);
        }

        public static SpeedLevel of(float speed) {
            if ((double)(speed = Math.abs(speed)) >= (Double)AllConfigs.SERVER.kinetics.fastSpeed.get()) {
                return FAST;
            }
            if ((double)speed >= (Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()) {
                return MEDIUM;
            }
            return NONE;
        }

        public float getSpeedValue() {
            switch (this) {
                case FAST: {
                    return ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
                }
                case MEDIUM: {
                    return ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
                }
            }
            return 0.0f;
        }

        public static String getFormattedSpeedText(float speed, boolean overstressed) {
            SpeedLevel speedLevel = SpeedLevel.of(speed);
            String color = overstressed ? TextFormatting.DARK_GRAY + "" + TextFormatting.STRIKETHROUGH : speedLevel.getTextColor() + "";
            String level = color + ItemDescription.makeProgressBar(3, speedLevel.ordinal());
            if (speedLevel == MEDIUM) {
                level = level + Lang.translate("tooltip.speedRequirement.medium", new Object[0]);
            }
            if (speedLevel == FAST) {
                level = level + Lang.translate("tooltip.speedRequirement.high", new Object[0]);
            }
            level = level + String.format(" (%s%s) ", IHaveGoggleInformation.format(Math.abs(speed)), Lang.translate("generic.unit.rpm", new Object[0]));
            return level;
        }
    }
}

