/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public abstract class BlockBreakingKineticTileEntity
extends KineticTileEntity {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected BlockPos breakingPos;

    public BlockBreakingKineticTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.destroyProgress == -1) {
            this.destroyNextTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.ticksUntilNextProgress == -1) {
            this.destroyNextTick();
        }
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    protected abstract BlockPos getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("Progress", this.destroyProgress);
        compound.func_74768_a("NextTick", this.ticksUntilNextProgress);
        if (this.breakingPos != null) {
            compound.func_218657_a("Breaking", (INBT)NBTUtil.func_186859_a((BlockPos)this.breakingPos));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        this.destroyProgress = compound.func_74762_e("Progress");
        this.ticksUntilNextProgress = compound.func_74762_e("NextTick");
        if (compound.func_74764_b("Breaking")) {
            this.breakingPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Breaking"));
        }
        super.read(compound, clientPacket);
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.destroyProgress != 0) {
            this.field_145850_b.func_175715_c(this.breakerId, this.breakingPos, -1);
        }
        super.func_145843_s();
    }

    @Override
    public void func_73660_a() {
        float blockHardness;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockState stateToBreak = this.field_145850_b.func_180495_p(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.func_185887_b((IBlockReader)this.field_145850_b, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.field_145850_b.func_175715_c(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += MathHelper.func_76125_a((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.field_145850_b.func_175715_c(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.field_145850_b.func_175715_c(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return BlockBreakingKineticTileEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !stateToBreak.func_185904_a().func_76224_d() && !(stateToBreak.func_177230_c() instanceof AirBlock) && blockHardness != -1.0f;
    }

    public void onBlockBroken(BlockState stateToBreak) {
        IFluidState ifluidstate = this.field_145850_b.func_204610_c(this.breakingPos);
        this.field_145850_b.func_217379_c(2001, this.breakingPos, Block.func_196246_j((BlockState)stateToBreak));
        TileEntity tileentity = stateToBreak.hasTileEntity() ? this.field_145850_b.func_175625_s(this.breakingPos) : null;
        Vec3d vec = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)this.breakingPos), this.field_145850_b.field_73012_v, 0.125f);
        Block.func_220070_a((BlockState)stateToBreak, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.breakingPos, (TileEntity)tileentity).forEach(stack -> {
            if (!stack.func_190926_b() && this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223603_f) && !this.field_145850_b.restoringBlockSnapshots) {
                ItemEntity itementity = new ItemEntity(this.field_145850_b, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, stack);
                itementity.func_174869_p();
                itementity.func_213317_d(Vec3d.field_186680_a);
                this.field_145850_b.func_217376_c((Entity)itementity);
            }
        });
        stateToBreak.func_215706_a(this.field_145850_b, this.breakingPos, ItemStack.field_190927_a);
        this.field_145850_b.func_180501_a(this.breakingPos, ifluidstate.func_206883_i(), 3);
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 100.0f);
    }
}

