/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.ContraptionBlockSource;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DropperMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.IMovedDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedProjectileDispenserBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class DispenserMovementBehaviour
extends DropperMovementBehaviour {
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_DISPENSE_ITEM_BEHAVIOURS = new HashMap();
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_PROJECTILE_DISPENSE_BEHAVIOURS = new HashMap();
    private static final DispenserLookup BEHAVIOUR_LOOKUP = new DispenserLookup();
    private static boolean spawneggsRegistered = false;

    public static void gatherMovedDispenseItemBehaviours() {
        IMovedDispenseItemBehaviour.init();
    }

    public static void registerMovedDispenseItemBehaviour(Item item, IMovedDispenseItemBehaviour movedDispenseItemBehaviour) {
        MOVED_DISPENSE_ITEM_BEHAVIOURS.put(item, movedDispenseItemBehaviour);
    }

    @Override
    protected void activate(MovementContext context, BlockPos pos) {
        DispenseItemLocation location;
        if (!spawneggsRegistered) {
            spawneggsRegistered = true;
            IMovedDispenseItemBehaviour.initSpawneggs();
        }
        if ((location = this.getDispenseLocation(context)).isEmpty()) {
            context.world.func_217379_c(1001, pos, 0);
        } else {
            ItemStack itemstack = this.getItemStackAt(location, context);
            if (MOVED_DISPENSE_ITEM_BEHAVIOURS.containsKey(itemstack.func_77973_b())) {
                this.setItemStackAt(location, MOVED_DISPENSE_ITEM_BEHAVIOURS.get(itemstack.func_77973_b()).dispense(itemstack, context, pos), context);
                return;
            }
            ItemStack backup = itemstack.func_77946_l();
            try {
                if (MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.containsKey(itemstack.func_77973_b())) {
                    this.setItemStackAt(location, MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.get(itemstack.func_77973_b()).dispense(itemstack, context, pos), context);
                    return;
                }
                IDispenseItemBehavior idispenseitembehavior = BEHAVIOUR_LOOKUP.func_149940_a(itemstack);
                if (idispenseitembehavior instanceof ProjectileDispenseBehavior) {
                    MovedProjectileDispenserBehaviour iMovedDispenseItemBehaviour = MovedProjectileDispenserBehaviour.of((ProjectileDispenseBehavior)idispenseitembehavior);
                    this.setItemStackAt(location, iMovedDispenseItemBehaviour.dispense(itemstack, context, pos), context);
                    MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.put(itemstack.func_77973_b(), iMovedDispenseItemBehaviour);
                    return;
                }
                Vec3d facingVec = new Vec3d(((Direction)context.state.func_177229_b((IProperty)DispenserBlock.field_176441_a)).func_176730_m());
                facingVec = (Vec3d)context.rotation.apply(facingVec);
                facingVec.func_72432_b();
                Direction clostestFacing = Direction.func_210769_a((double)facingVec.field_72450_a, (double)facingVec.field_72448_b, (double)facingVec.field_72449_c);
                ContraptionBlockSource blockSource = new ContraptionBlockSource(context, pos, clostestFacing);
                if (idispenseitembehavior.getClass() != DefaultDispenseItemBehavior.class) {
                    this.setItemStackAt(location, idispenseitembehavior.dispense((IBlockSource)blockSource, itemstack), context);
                    return;
                }
            }
            catch (NullPointerException ignored) {
                itemstack = backup;
            }
            this.setItemStackAt(location, defaultBehaviour.dispense(itemstack, context, pos), context);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class DispenserLookup
    extends DispenserBlock {
        protected DispenserLookup() {
            super(Block.Properties.func_200950_a((Block)Blocks.field_150367_z));
        }

        public IDispenseItemBehavior func_149940_a(ItemStack itemStack) {
            return super.func_149940_a(itemStack);
        }
    }
}

