/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class DropperMovementBehaviour
extends MovementBehaviour {
    protected static final MovedDefaultDispenseItemBehaviour defaultBehaviour = new MovedDefaultDispenseItemBehaviour();
    private static final Random RNG = new Random();

    protected void activate(MovementContext context, BlockPos pos) {
        DispenseItemLocation location = this.getDispenseLocation(context);
        if (location.isEmpty()) {
            context.world.func_217379_c(1001, pos, 0);
        } else {
            this.setItemStackAt(location, defaultBehaviour.dispense(this.getItemStackAt(location, context), context, pos), context);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.field_72995_K) {
            return;
        }
        this.collectItems(context);
        this.activate(context, pos);
    }

    private void collectItems(MovementContext context) {
        this.getStacks(context).stream().filter(itemStack -> !itemStack.func_190926_b() && itemStack.func_77973_b() != Items.field_190931_a && itemStack.func_77976_d() > itemStack.func_190916_E()).forEach(itemStack -> itemStack.func_190917_f(ItemHelper.extract((IItemHandler)context.contraption.inventory, arg_0 -> ((ItemStack)itemStack).func_77969_a(arg_0), ItemHelper.ExtractionCountMode.UPTO, itemStack.func_77976_d() - itemStack.func_190916_E(), false).func_190916_E()));
    }

    private void updateTemporaryData(MovementContext context) {
        if (!(context.temporaryData instanceof NonNullList) && context.world instanceof ServerWorld) {
            NonNullList stacks = NonNullList.func_191197_a((int)DropperMovementBehaviour.getInvSize(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)context.tileData, (NonNullList)stacks);
            context.temporaryData = stacks;
        }
    }

    private NonNullList<ItemStack> getStacks(MovementContext context) {
        this.updateTemporaryData(context);
        return (NonNullList)context.temporaryData;
    }

    private ArrayList<DispenseItemLocation> getUseableLocations(MovementContext context) {
        ArrayList<DispenseItemLocation> useable = new ArrayList<DispenseItemLocation>();
        for (int slot = 0; slot < DropperMovementBehaviour.getInvSize(); ++slot) {
            DispenseItemLocation location = new DispenseItemLocation(true, slot);
            ItemStack testStack = this.getItemStackAt(location, context);
            if (testStack == null || testStack.func_190926_b()) continue;
            if (testStack.func_77976_d() == 1) {
                location = new DispenseItemLocation(false, ItemHelper.findFirstMatchingSlotIndex((IItemHandler)context.contraption.inventory, arg_0 -> ((ItemStack)testStack).func_77969_a(arg_0)));
                if (this.getItemStackAt(location, context).func_190926_b()) continue;
                useable.add(location);
                continue;
            }
            if (testStack.func_190916_E() < 2) continue;
            useable.add(location);
        }
        return useable;
    }

    @Override
    public void writeExtraData(MovementContext context) {
        NonNullList<ItemStack> stacks = this.getStacks(context);
        if (stacks == null) {
            return;
        }
        ItemStackHelper.func_191282_a((CompoundNBT)context.tileData, stacks);
    }

    @Override
    public void stopMoving(MovementContext context) {
        super.stopMoving(context);
        this.writeExtraData(context);
    }

    protected DispenseItemLocation getDispenseLocation(MovementContext context) {
        int i = -1;
        int j = 1;
        ArrayList<DispenseItemLocation> useableLocations = this.getUseableLocations(context);
        for (int k = 0; k < useableLocations.size(); ++k) {
            if (RNG.nextInt(j++) != 0) continue;
            i = k;
        }
        if (i < 0) {
            return DispenseItemLocation.NONE;
        }
        return (DispenseItemLocation)useableLocations.get(i);
    }

    protected ItemStack getItemStackAt(DispenseItemLocation location, MovementContext context) {
        if (location.isInternal()) {
            return (ItemStack)this.getStacks(context).get(location.getSlot());
        }
        return context.contraption.inventory.getStackInSlot(location.getSlot());
    }

    protected void setItemStackAt(DispenseItemLocation location, ItemStack stack, MovementContext context) {
        if (location.isInternal()) {
            this.getStacks(context).set(location.getSlot(), (Object)stack);
        } else {
            context.contraption.inventory.setStackInSlot(location.getSlot(), stack);
        }
    }

    private static int getInvSize() {
        return 9;
    }
}

