/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.IMovedDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import net.minecraft.block.DispenserBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MovedDefaultDispenseItemBehaviour
implements IMovedDispenseItemBehaviour {
    private static final MovedDefaultDispenseItemBehaviour defaultInstance = new MovedDefaultDispenseItemBehaviour();

    public static void doDispense(World p_82486_0_, ItemStack p_82486_1_, int p_82486_2_, Vec3d facing, BlockPos p_82486_4_, MovementContext context) {
        double d0 = (double)p_82486_4_.func_177958_n() + facing.field_72450_a + 0.5;
        double d1 = (double)p_82486_4_.func_177956_o() + facing.field_72448_b + 0.5;
        double d2 = (double)p_82486_4_.func_177952_p() + facing.field_72449_c + 0.5;
        d1 = Direction.func_210769_a((double)facing.field_72450_a, (double)facing.field_72448_b, (double)facing.field_72449_c).func_176740_k() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(p_82486_0_, d0, d1, d2, p_82486_1_);
        double d3 = p_82486_0_.field_73012_v.nextDouble() * 0.1 + 0.2;
        itementity.func_213293_j(p_82486_0_.field_73012_v.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.func_82615_a() * d3 + context.motion.field_72450_a, p_82486_0_.field_73012_v.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.func_82617_b() * d3 + context.motion.field_72448_b, p_82486_0_.field_73012_v.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.func_82616_c() * d3 + context.motion.field_72449_c);
        p_82486_0_.func_217376_c((Entity)itementity);
    }

    @Override
    public ItemStack dispense(ItemStack itemStack, MovementContext context, BlockPos pos) {
        Vec3d facingVec = new Vec3d(((Direction)context.state.func_177229_b((IProperty)DispenserBlock.field_176441_a)).func_176730_m());
        facingVec = (Vec3d)context.rotation.apply(facingVec);
        facingVec.func_72432_b();
        Direction closestToFacing = this.getClosestFacingDirection(facingVec);
        IInventory iinventory = HopperTileEntity.func_195484_a((World)context.world, (BlockPos)pos.func_177972_a(closestToFacing));
        if (iinventory == null) {
            this.playDispenseSound((IWorld)context.world, pos);
            this.spawnDispenseParticles((IWorld)context.world, pos, closestToFacing);
            return this.dispenseStack(itemStack, context, pos, facingVec);
        }
        if (HopperTileEntity.func_174918_a(null, (IInventory)iinventory, (ItemStack)itemStack.func_77946_l().func_77979_a(1), (Direction)closestToFacing.func_176734_d()).func_190926_b()) {
            itemStack.func_190918_g(1);
        }
        return itemStack;
    }

    protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3d facing) {
        ItemStack itemstack = itemStack.func_77979_a(1);
        MovedDefaultDispenseItemBehaviour.doDispense(context.world, itemstack, 6, facing, pos, context);
        return itemStack;
    }

    protected void playDispenseSound(IWorld world, BlockPos pos) {
        world.func_217379_c(1000, pos, 0);
    }

    protected void spawnDispenseParticles(IWorld world, BlockPos pos, Vec3d facing) {
        this.spawnDispenseParticles(world, pos, this.getClosestFacingDirection(facing));
    }

    protected void spawnDispenseParticles(IWorld world, BlockPos pos, Direction direction) {
        world.func_217379_c(2000, pos, direction.func_176745_a());
    }

    protected Direction getClosestFacingDirection(Vec3d exactFacing) {
        return Direction.func_210769_a((double)exactFacing.field_72450_a, (double)exactFacing.field_72448_b, (double)exactFacing.field_72449_c);
    }

    protected ItemStack placeItemInInventory(ItemStack consumedFrom, ItemStack output, MovementContext context, BlockPos pos, Vec3d facing) {
        consumedFrom.func_190918_g(1);
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)context.contraption.inventory, (ItemStack)output.func_77946_l(), (boolean)false);
        if (!remainder.func_190926_b()) {
            defaultInstance.dispenseStack(output, context, pos, facing);
        }
        return consumedFrom;
    }
}

