/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelControllerTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CrushingWheelControllerBlock
extends Block
implements ITE<CrushingWheelControllerTileEntity> {
    public static final BooleanProperty VALID = BooleanProperty.func_177716_a((String)"valid");

    public CrushingWheelControllerBlock(Block.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CRUSHING_WHEEL_CONTROLLER.create();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{VALID});
        super.func_206840_a(builder);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.func_177229_b((IProperty)VALID)).booleanValue()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.processingEntity == entityIn) {
                entityIn.func_213295_a(state, new Vec3d(0.25, (double)0.05f, 0.25));
            }
        });
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        try {
            CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity(worldIn, entityIn.func_180425_c().func_177977_b());
            if (te.crushingspeed == 0.0f) {
                return;
            }
            if (entityIn instanceof ItemEntity) {
                ((ItemEntity)entityIn).func_174867_a(10);
            }
            if (te.isOccupied()) {
                return;
            }
            boolean isPlayer = entityIn instanceof PlayerEntity;
            if (isPlayer && ((PlayerEntity)entityIn).func_184812_l_()) {
                return;
            }
            if (isPlayer && entityIn.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                return;
            }
            te.startCrushing(entityIn);
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((IProperty)VALID)).booleanValue()) {
            return;
        }
        if (rand.nextInt(1) != 0) {
            return;
        }
        double d0 = (float)pos.func_177958_n() + rand.nextFloat();
        double d1 = (float)pos.func_177956_o() + rand.nextFloat();
        double d2 = (float)pos.func_177952_p() + rand.nextFloat();
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197614_g, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.updateSpeed(stateIn, worldIn.func_201672_e(), currentPos);
        return stateIn;
    }

    public void updateSpeed(BlockState state, World world, BlockPos pos) {
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            if (!((Boolean)state.func_177229_b((IProperty)VALID)).booleanValue()) {
                if (te.crushingspeed != 0.0f) {
                    te.crushingspeed = 0.0f;
                    te.sendData();
                }
                return;
            }
            for (Direction d : Iterate.horizontalDirections) {
                BlockState neighbour = world.func_180495_p(pos.func_177972_a(d));
                if (!AllBlocks.CRUSHING_WHEEL.has(neighbour) || neighbour.func_177229_b((IProperty)BlockStateProperties.field_208148_A) == d.func_176740_k()) continue;
                KineticTileEntity wheelTe = (KineticTileEntity)world.func_175625_s(pos.func_177972_a(d));
                te.crushingspeed = Math.abs(wheelTe.getSpeed() / 50.0f);
                te.sendData();
                break;
            }
        });
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((IProperty)VALID)).booleanValue()) {
            return VoxelShapes.func_197868_b();
        }
        Entity entity = context.getEntity();
        if (entity != null) {
            CompoundNBT data;
            if (entity != null && (data = entity.getPersistentData()).func_74764_b("BypassCrushingWheel") && pos.equals((Object)NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("BypassCrushingWheel")))) {
                return VoxelShapes.func_197880_a();
            }
            if (new AxisAlignedBB(pos).func_72318_a(entity.func_213303_ch())) {
                return VoxelShapes.func_197880_a();
            }
            try {
                CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity(worldIn, pos);
                if (te.processingEntity == entity) {
                    return VoxelShapes.func_197880_a();
                }
            }
            catch (ITE.TileEntityException tileEntityException) {
                // empty catch block
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inventory));
        worldIn.func_175713_t(pos);
    }

    @Override
    public Class<CrushingWheelControllerTileEntity> getTileEntityClass() {
        return CrushingWheelControllerTileEntity.class;
    }
}

