/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerHandler;
import com.simibubi.create.content.contraptions.components.deployer.DeployerRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
extends MovementBehaviour {
    @Override
    public Vec3d getActiveAreaOffset(MovementContext context) {
        return new Vec3d(((Direction)context.state.func_177229_b((IProperty)DeployerBlock.FACING)).func_176730_m()).func_186678_a(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.field_72995_K) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        if (mode == DeployerTileEntity.Mode.USE && !DeployerHandler.shouldActivate(player.func_184614_ca(), context.world, pos)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.tryDisposeOfExcess(context);
        context.stall = player.blockBreakingProgress != null;
    }

    public void activate(MovementContext context, BlockPos pos, DeployerFakePlayer player, DeployerTileEntity.Mode mode) {
        Vec3d facingVec = new Vec3d(((Direction)context.state.func_177229_b((IProperty)DeployerBlock.FACING)).func_176730_m());
        facingVec = (Vec3d)context.rotation.apply(facingVec);
        Vec3d vec = context.position.func_178788_d(facingVec.func_186678_a(2.0));
        player.field_70177_z = AbstractContraptionEntity.yawFromVector(facingVec);
        player.field_70125_A = AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f;
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_72995_K) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        Pair<BlockPos, Float> blockBreakingProgress = player.blockBreakingProgress;
        if (blockBreakingProgress != null) {
            int timer = context.data.func_74762_e("Timer");
            if (timer < 20) {
                context.data.func_74768_a("Timer", ++timer);
                return;
            }
            context.data.func_82580_o("Timer");
            this.activate(context, (BlockPos)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.blockBreakingProgress != null;
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.field_72995_K) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.tileData.func_218657_a("Inventory", (INBT)player.field_71071_by.func_70442_a(new ListNBT()));
        player.func_70106_y();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.func_184614_ca().func_190926_b()) {
            ItemStack filter = this.getFilter(context);
            ItemStack held = ItemHelper.extract((IItemHandler)context.contraption.inventory, stack -> FilterItem.test(context.world, stack, filter), 1, false);
            player.func_184611_a(Hand.MAIN_HAND, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        PlayerInventory inv = player.field_71071_by;
        ItemStack filter = this.getFilter(context);
        for (List list : Arrays.asList(inv.field_70460_b, inv.field_184439_c, inv.field_70462_a)) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.func_190926_b() || list == inv.field_70462_a && i == inv.field_70461_c && FilterItem.test(context.world, itemstack, filter)) continue;
                this.dropItem(context, itemstack);
                list.set(i, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.data.func_218657_a("HeldItem", (INBT)player.func_184614_ca().serializeNBT());
    }

    private DeployerFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerFakePlayer) && context.world instanceof ServerWorld) {
            DeployerFakePlayer deployerFakePlayer = new DeployerFakePlayer((ServerWorld)context.world);
            deployerFakePlayer.field_71071_by.func_70443_b(context.tileData.func_150295_c("Inventory", 10));
            if (context.data.func_74764_b("HeldItem")) {
                deployerFakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.func_199557_a((CompoundNBT)context.data.func_74775_l("HeldItem")));
            }
            context.tileData.func_82580_o("Inventory");
            context.temporaryData = deployerFakePlayer;
        }
        return (DeployerFakePlayer)((Object)context.temporaryData);
    }

    private ItemStack getFilter(MovementContext context) {
        return ItemStack.func_199557_a((CompoundNBT)context.tileData.func_74775_l("Filter"));
    }

    private DeployerTileEntity.Mode getMode(MovementContext context) {
        return NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
    }

    @Override
    public void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffers) {
        DeployerRenderer.renderInContraption(context, ms, msLocal, buffers);
    }
}

