/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.actors.SeatBlock;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AllContraptionTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementTraits;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedFluidStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateBlock;
import com.simibubi.create.content.logistics.block.redstone.RedstoneContactBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Contraption {
    public AbstractContraptionEntity entity;
    public CombinedInvWrapper inventory;
    public CombinedTankWrapper fluidInventory;
    public AxisAlignedBB bounds;
    public BlockPos anchor;
    public boolean stalled;
    protected Map<BlockPos, Template.BlockInfo> blocks = new HashMap<BlockPos, Template.BlockInfo>();
    protected Map<BlockPos, MountedStorage> storage = new HashMap<BlockPos, MountedStorage>();
    protected Map<BlockPos, MountedFluidStorage> fluidStorage;
    protected List<MutablePair<Template.BlockInfo, MovementContext>> actors;
    protected Set<Pair<BlockPos, Direction>> superglue;
    protected List<BlockPos> seats = new ArrayList<BlockPos>();
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    private List<SuperGlueEntity> glueToRemove;
    private Map<BlockPos, Entity> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    public Map<BlockPos, TileEntity> presentTileEntities;
    public List<TileEntity> renderedTileEntities;

    public Contraption() {
        this.actors = new ArrayList<MutablePair<Template.BlockInfo, MovementContext>>();
        this.superglue = new HashSet<Pair<BlockPos, Direction>>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.fluidStorage = new HashMap<BlockPos, MountedFluidStorage>();
        this.glueToRemove = new ArrayList<SuperGlueEntity>();
        this.initialPassengers = new HashMap<BlockPos, Entity>();
        this.presentTileEntities = new HashMap<BlockPos, TileEntity>();
        this.renderedTileEntities = new ArrayList<TileEntity>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
    }

    public abstract boolean assemble(World var1, BlockPos var2);

    protected abstract boolean canAxisBeStabilized(Direction.Axis var1);

    protected abstract AllContraptionTypes getType();

    protected boolean customBlockPlacement(IWorld world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean customBlockRemoval(IWorld world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction forcedDirection, List<BlockPos> frontier) {
        return true;
    }

    public static Contraption fromNBT(World world, CompoundNBT nbt, boolean spawnData) {
        String type = nbt.func_74779_i("Type");
        Contraption contraption = AllContraptionTypes.fromType(type);
        contraption.readNBT(world, nbt, spawnData);
        return contraption;
    }

    public boolean searchMovedStructure(World world, BlockPos pos, @Nullable Direction forcedDirection) {
        this.initialPassengers.clear();
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AxisAlignedBB(BlockPos.field_177992_a);
        }
        if (!BlockMovementTraits.isBrittle(world.func_180495_p(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, (BlockPos)frontier.remove(0), forcedDirection, frontier, visited)) continue;
            return false;
        }
        return false;
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            BlockPos pos;
            World world;
            Direction face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            if (!subContraption.assemble(world = entity.field_70170_p, pos = blockFace.getPos())) continue;
            subContraption.removeBlocksFromWorld(world, BlockPos.field_177992_a);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, Optional.of(face));
            BlockPos anchor = blockFace.getConnectedPos();
            movedContraption.func_70107_b((float)anchor.func_177958_n() + 0.5f, anchor.func_177956_o(), (float)anchor.func_177952_p() + 0.5f);
            world.func_217376_c((Entity)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.func_110124_au(), new BlockFace(this.toLocalPos(pos), face));
        }
        List list = this.storage.values().stream().map(MountedStorage::getItemHandler).collect(Collectors.toList());
        this.inventory = new CombinedInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
        List fluidHandlers = this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList());
        this.fluidInventory = new CombinedTankWrapper((IFluidHandler[])Arrays.copyOf(fluidHandlers.toArray(), fluidHandlers.size(), IFluidHandler[].class));
    }

    public void onEntityInitialize(World world, AbstractContraptionEntity contraptionEntity) {
        if (world.field_72995_K) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.func_217357_a(OrientedContraptionEntity.class, contraptionEntity.func_174813_aQ().func_186662_g(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.func_110124_au())) continue;
            orientedCE.func_184220_m(contraptionEntity);
        }
        for (BlockPos seatPos : this.getSeats()) {
            int seatIndex;
            Entity passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    public void onEntityTick(World world) {
        this.fluidStorage.forEach((pos, mfs) -> mfs.tick(this.entity, (BlockPos)pos, world.field_72995_K));
    }

    protected boolean moveBlock(World world, BlockPos pos, Direction forcedDirection, List<BlockPos> frontier, Set<BlockPos> visited) {
        BlockPos otherPartPos;
        visited.add(pos);
        frontier.remove(pos);
        if (!world.func_195588_v(pos)) {
            return false;
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        if (!BlockMovementTraits.movementNecessary(world, pos)) {
            return true;
        }
        if (!this.movementAllowed(world, pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (AllBlocks.ADJUSTABLE_CRATE.has(state)) {
            AdjustableCrateBlock.splitCrate(world, pos);
        }
        if (AllBlocks.BELT.has(state)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (state.func_177230_c() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.func_177230_c() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.func_177230_c() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (state.func_177230_c() instanceof DoorBlock && !visited.contains(otherPartPos = pos.func_177981_b(state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER ? 1 : -1))) {
            frontier.add(otherPartPos);
        }
        BlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if (!visited.contains(pos.func_177977_b()) && AllBlocks.CART_ASSEMBLER.has(stateBelow)) {
            frontier.add(pos.func_177977_b());
        }
        Map<Direction, SuperGlueEntity> superglue = SuperGlueHandler.gatherGlue((IWorld)world, pos);
        boolean isStickyBlock = state.isStickyBlock();
        for (Direction offset : Iterate.directions) {
            BlockPos offsetPos = pos.func_177972_a(offset);
            BlockState blockState = world.func_180495_p(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(world, offsetPos)) {
                if (offset != forcedDirection || !isStickyBlock) continue;
                return false;
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = superglue.containsKey(offset);
            boolean blockAttachedTowardsFace = BlockMovementTraits.isBlockAttachedTowards((IBlockReader)world, offsetPos, blockState, offset.func_176734_d());
            boolean brittle = BlockMovementTraits.isBrittle(blockState);
            if (!wasVisited && (isStickyBlock && !brittle || blockAttachedTowardsFace || faceHasGlue)) {
                frontier.add(offsetPos);
            }
            if (!faceHasGlue) continue;
            this.addGlue(superglue.get(offset));
        }
        this.addBlock(pos, this.capture(world, pos));
        return this.blocks.size() <= (Integer)AllConfigs.SERVER.kinetics.maxBlocksMoved.get();
    }

    private void moveBearing(BlockPos pos, List<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)MechanicalBearingBlock.FACING);
        if (!this.canAxisBeStabilized(facing.func_176740_k())) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(BlockPos pos, List<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        BlockPos prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(World world, BlockPos pos) {
        SeatEntity seat;
        List passengers;
        BlockPos local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.func_217357_a(SeatEntity.class, new AxisAlignedBB(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.get(0))).func_184188_bt()).isEmpty()) {
            this.initialPassengers.put(local, (Entity)passengers.get(0));
        }
    }

    private void movePulley(World world, BlockPos pos, List<BlockPos> frontier, Set<BlockPos> visited) {
        int limit = (Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get();
        BlockPos ropePos = pos;
        while (limit-- >= 0 && world.func_195588_v(ropePos = ropePos.func_177977_b())) {
            BlockState ropeState = world.func_180495_p(ropePos);
            Block block = ropeState.func_177230_c();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(World world, BlockPos pos, List<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockState blockState;
        BlockPos searchPos;
        int limit = (Integer)AllConfigs.SERVER.kinetics.maxPistonPoles.get();
        Direction direction = (Direction)state.func_177229_b((IProperty)MechanicalPistonBlock.FACING);
        if (state.func_177229_b(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            searchPos = pos;
            while (limit-- >= 0) {
                blockState = world.func_180495_p(searchPos = searchPos.func_177972_a(direction));
                if (MechanicalPistonBlock.isExtensionPole(blockState)) {
                    if (((Direction)blockState.func_177229_b((IProperty)PistonExtensionPoleBlock.field_176387_N)).func_176740_k() != direction.func_176740_k()) break;
                    if (visited.contains(searchPos)) continue;
                    frontier.add(searchPos);
                    continue;
                }
                if (!MechanicalPistonBlock.isPistonHead(blockState) || visited.contains(searchPos)) break;
                frontier.add(searchPos);
                break;
            }
            if (limit <= -1) {
                return false;
            }
        }
        searchPos = pos;
        while (limit-- >= 0 && MechanicalPistonBlock.isExtensionPole(blockState = world.func_180495_p(searchPos = searchPos.func_177972_a(direction.func_176734_d()))) && ((Direction)blockState.func_177229_b((IProperty)PistonExtensionPoleBlock.field_176387_N)).func_176740_k() == direction.func_176740_k()) {
            if (visited.contains(searchPos)) continue;
            frontier.add(searchPos);
        }
        return limit > -1;
    }

    private boolean moveChassis(World world, BlockPos pos, Direction movementDirection, List<BlockPos> frontier, Set<BlockPos> visited) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ChassisTileEntity)) {
            return false;
        }
        ChassisTileEntity chassis = (ChassisTileEntity)te;
        chassis.addAttachedChasses(frontier, visited);
        List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (BlockPos blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<Template.BlockInfo, TileEntity> capture(World world, BlockPos pos) {
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_177230_c() instanceof ChestBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        if (AllBlocks.ADJUSTABLE_CRATE.has(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)AdjustableCrateBlock.DOUBLE, (Comparable)Boolean.valueOf(false));
        }
        if (AllBlocks.REDSTONE_CONTACT.has(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.func_177230_c() instanceof AbstractButtonBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)AbstractButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        if (blockstate.func_177230_c() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        CompoundNBT compoundnbt = this.getTileEntityNBT(world, pos);
        TileEntity tileentity = world.func_175625_s(pos);
        return Pair.of((Object)new Template.BlockInfo(pos, blockstate, compoundnbt), (Object)tileentity);
    }

    protected void addBlock(BlockPos pos, Pair<Template.BlockInfo, TileEntity> pair) {
        Template.BlockInfo blockInfo;
        Template.BlockInfo captured = (Template.BlockInfo)pair.getKey();
        BlockPos localPos = pos.func_177973_b((Vec3i)this.anchor);
        if (this.blocks.put(localPos, blockInfo = new Template.BlockInfo(localPos, captured.field_186243_b, captured.field_186244_c)) != null) {
            return;
        }
        this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(localPos));
        TileEntity te = (TileEntity)pair.getValue();
        if (te != null && MountedStorage.canUseAsStorage(te)) {
            this.storage.put(localPos, new MountedStorage(te));
        }
        if (te != null && MountedFluidStorage.canUseAsStorage(te)) {
            this.fluidStorage.put(localPos, new MountedFluidStorage(te));
        }
        if (AllMovementBehaviours.contains(captured.field_186243_b.func_177230_c())) {
            this.actors.add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)blockInfo, null));
        }
    }

    @Nullable
    protected CompoundNBT getTileEntityNBT(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity == null) {
            return null;
        }
        CompoundNBT nbt = tileentity.func_189515_b(new CompoundNBT());
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        if (tileentity instanceof FluidTankTileEntity && nbt.func_74764_b("Controller")) {
            nbt.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.toLocalPos(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Controller")))));
        }
        return nbt;
    }

    protected void addGlue(SuperGlueEntity entity) {
        BlockPos pos = entity.getHangingPosition();
        Direction direction = entity.getFacingDirection();
        this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)this.toLocalPos(pos), (Object)direction));
        this.glueToRemove.add(entity);
    }

    protected BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.func_177973_b((Vec3i)this.anchor);
    }

    protected boolean movementAllowed(World world, BlockPos pos) {
        return BlockMovementTraits.movementAllowed(world, pos);
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    public void readNBT(World world, CompoundNBT nbt, boolean spawnData) {
        this.blocks.clear();
        this.presentTileEntities.clear();
        this.renderedTileEntities.clear();
        nbt.func_150295_c("Blocks", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            final Template.BlockInfo info = new Template.BlockInfo(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")), NBTUtil.func_190008_d((CompoundNBT)comp.func_74775_l("Block")), comp.func_74764_b("Data") ? comp.func_74775_l("Data") : null);
            this.blocks.put(info.field_186242_a, info);
            if (world.field_72995_K) {
                Block block = info.field_186243_b.func_177230_c();
                CompoundNBT tag = info.field_186244_c;
                MovementBehaviour movementBehaviour = AllMovementBehaviours.of(block);
                if (tag == null || movementBehaviour != null && movementBehaviour.hasSpecialMovementRenderer()) {
                    return;
                }
                tag.func_74768_a("x", info.field_186242_a.func_177958_n());
                tag.func_74768_a("y", info.field_186242_a.func_177956_o());
                tag.func_74768_a("z", info.field_186242_a.func_177952_p());
                final TileEntity te = TileEntity.func_203403_c((CompoundNBT)tag);
                if (te == null) {
                    return;
                }
                te.func_226984_a_((World)new WrappedWorld(world){

                    @Override
                    public BlockState func_180495_p(BlockPos pos) {
                        if (!pos.equals((Object)te.func_174877_v())) {
                            return Blocks.field_150350_a.func_176223_P();
                        }
                        return info.field_186243_b;
                    }
                }, te.func_174877_v());
                if (te instanceof KineticTileEntity) {
                    ((KineticTileEntity)te).setSpeed(0.0f);
                }
                te.func_195044_w();
                this.presentTileEntities.put(info.field_186242_a, te);
                this.renderedTileEntities.add(te);
            }
        });
        this.actors.clear();
        nbt.func_150295_c("Actors", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            Template.BlockInfo info = this.blocks.get(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")));
            MovementContext context = MovementContext.readNBT(world, info, comp, this);
            this.getActors().add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)info, (Object)context));
        });
        this.superglue.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Superglue", 10), c -> this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), (Object)Direction.func_82600_a((int)c.func_74771_c("Direction")))));
        this.seats.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Seats", 10), c -> this.seats.add(NBTUtil.func_186861_c((CompoundNBT)c)));
        this.seatMapping.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Passengers", 10), c -> this.seatMapping.put(NBTUtil.func_186860_b((CompoundNBT)c.func_74775_l("Id")), c.func_74762_e("Seat")));
        this.stabilizedSubContraptions.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("SubContraptions", 10), c -> this.stabilizedSubContraptions.put(NBTUtil.func_186860_b((CompoundNBT)c.func_74775_l("Id")), BlockFace.fromNBT(c.func_74775_l("Location"))));
        this.storage.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Storage", 10), c -> this.storage.put(NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), MountedStorage.deserialize(c.func_74775_l("Data"))));
        this.fluidStorage.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("FluidStorage", 10), c -> this.fluidStorage.put(NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), MountedFluidStorage.deserialize(c.func_74775_l("Data"))));
        if (spawnData) {
            this.fluidStorage.forEach((pos, mfs) -> {
                TileEntity tileEntity = this.presentTileEntities.get(pos);
                if (!(tileEntity instanceof FluidTankTileEntity)) {
                    return;
                }
                FluidTankTileEntity tank = (FluidTankTileEntity)tileEntity;
                IFluidTank tankInventory = tank.getTankInventory();
                if (tankInventory instanceof FluidTank) {
                    ((FluidTank)tankInventory).setFluid(mfs.tank.getFluid());
                }
                tank.getFluidLevel().start(tank.getFillState());
                mfs.assignTileEntity(tank);
            });
        }
        IItemHandlerModifiable[] handlers = new IItemHandlerModifiable[this.storage.size()];
        int index = 0;
        for (MountedStorage mountedStorage : this.storage.values()) {
            handlers[index++] = mountedStorage.getItemHandler();
        }
        IFluidHandler[] fluidHandlers = new IFluidHandler[this.fluidStorage.size()];
        index = 0;
        for (MountedFluidStorage mountedStorage : this.fluidStorage.values()) {
            fluidHandlers[index++] = mountedStorage.getFluidHandler();
        }
        this.inventory = new CombinedInvWrapper(handlers);
        this.fluidInventory = new CombinedTankWrapper(fluidHandlers);
        if (nbt.func_74764_b("BoundsFront")) {
            this.bounds = NBTHelper.readAABB(nbt.func_150295_c("BoundsFront", 5));
        }
        this.stalled = nbt.func_74767_n("Stalled");
        this.anchor = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Anchor"));
    }

    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Type", this.getType().id);
        ListNBT blocksNBT = new ListNBT();
        for (Template.BlockInfo blockInfo : this.blocks.values()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("Block", (INBT)NBTUtil.func_190009_a((BlockState)blockInfo.field_186243_b));
            compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockInfo.field_186242_a));
            if (blockInfo.field_186244_c != null) {
                compoundNBT.func_218657_a("Data", (INBT)blockInfo.field_186244_c);
            }
            blocksNBT.add((Object)compoundNBT);
        }
        ListNBT actorsNBT = new ListNBT();
        for (MutablePair<Template.BlockInfo, MovementContext> mutablePair : this.getActors()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((Template.BlockInfo)mutablePair.left).field_186242_a));
            AllMovementBehaviours.of(((Template.BlockInfo)mutablePair.left).field_186243_b).writeExtraData((MovementContext)mutablePair.right);
            ((MovementContext)mutablePair.right).writeToNBT(compoundNBT);
            actorsNBT.add((Object)compoundNBT);
        }
        ListNBT listNBT = new ListNBT();
        for (Pair<BlockPos, Direction> pair : this.superglue) {
            CompoundNBT c = new CompoundNBT();
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)pair.getKey())));
            c.func_74774_a("Direction", (byte)((Direction)pair.getValue()).func_176745_a());
            listNBT.add((Object)c);
        }
        ListNBT listNBT2 = new ListNBT();
        if (!spawnPacket) {
            for (BlockPos pos : this.storage.keySet()) {
                CompoundNBT c = new CompoundNBT();
                MountedStorage mountedStorage = this.storage.get(pos);
                if (!mountedStorage.isValid()) continue;
                c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                c.func_218657_a("Data", (INBT)mountedStorage.serialize());
                listNBT2.add((Object)c);
            }
        }
        ListNBT listNBT3 = new ListNBT();
        for (BlockPos pos : this.fluidStorage.keySet()) {
            CompoundNBT c = new CompoundNBT();
            MountedFluidStorage mountedStorage = this.fluidStorage.get(pos);
            if (!mountedStorage.isValid()) continue;
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            c.func_218657_a("Data", (INBT)mountedStorage.serialize());
            listNBT3.add((Object)c);
        }
        nbt.func_218657_a("Seats", (INBT)NBTHelper.writeCompoundList(this.getSeats(), NBTUtil::func_186859_a));
        nbt.func_218657_a("Passengers", (INBT)NBTHelper.writeCompoundList(this.getSeatMapping().entrySet(), e -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Id", (INBT)NBTUtil.func_186862_a((UUID)((UUID)e.getKey())));
            tag.func_74768_a("Seat", ((Integer)e.getValue()).intValue());
            return tag;
        }));
        nbt.func_218657_a("SubContraptions", (INBT)NBTHelper.writeCompoundList(this.stabilizedSubContraptions.entrySet(), e -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Id", (INBT)NBTUtil.func_186862_a((UUID)((UUID)e.getKey())));
            tag.func_218657_a("Location", (INBT)((BlockFace)e.getValue()).serializeNBT());
            return tag;
        }));
        nbt.func_218657_a("Blocks", (INBT)blocksNBT);
        nbt.func_218657_a("Actors", (INBT)actorsNBT);
        nbt.func_218657_a("Superglue", (INBT)listNBT);
        nbt.func_218657_a("Storage", (INBT)listNBT2);
        nbt.func_218657_a("FluidStorage", (INBT)listNBT3);
        nbt.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)this.anchor));
        nbt.func_74757_a("Stalled", this.stalled);
        if (this.bounds != null) {
            ListNBT bb = NBTHelper.writeAABB(this.bounds);
            nbt.func_218657_a("BoundsFront", (INBT)bb);
        }
        return nbt;
    }

    public void removeBlocksFromWorld(World world, BlockPos offset) {
        this.storage.values().forEach(MountedStorage::removeStorageFromWorld);
        this.fluidStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
        this.glueToRemove.forEach(Entity::func_70106_y);
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<Template.BlockInfo> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                BlockPos add;
                Template.BlockInfo block = iterator.next();
                if (brittles != BlockMovementTraits.isBrittle(block.field_186243_b) || this.customBlockRemoval((IWorld)world, add = block.field_186242_a.func_177971_a((Vec3i)this.anchor).func_177971_a((Vec3i)offset), block.field_186243_b)) continue;
                BlockState oldState = world.func_180495_p(add);
                Block blockIn = oldState.func_177230_c();
                if (block.field_186243_b.func_177230_c() != blockIn) {
                    iterator.remove();
                }
                world.func_201672_e().func_175713_t(add);
                int flags = 112;
                if (blockIn instanceof IWaterLoggable && oldState.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && ((Boolean)oldState.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
                    world.func_180501_a(add, Blocks.field_150355_j.func_176223_P(), flags);
                    continue;
                }
                world.func_180501_a(add, Blocks.field_150350_a.func_176223_P(), flags);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            Template.BlockInfo block = (Template.BlockInfo)object.next();
            BlockPos add = block.field_186242_a.func_177971_a((Vec3i)this.anchor).func_177971_a((Vec3i)offset);
            world.markAndNotifyBlock(add, null, block.field_186243_b, Blocks.field_150350_a.func_176223_P(), 67);
        }
    }

    public void addBlocksToWorld(World world, StructureTransform transform) {
        int i;
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (Template.BlockInfo block : this.blocks.values()) {
                Object mountedStorage;
                BlockState blockState;
                BlockState state;
                BlockPos targetPos;
                if (nonBrittles == BlockMovementTraits.isBrittle(block.field_186243_b) || this.customBlockPlacement((IWorld)world, targetPos = transform.apply(block.field_186242_a), state = transform.apply(block.field_186243_b))) continue;
                if (nonBrittles) {
                    for (Direction face : Iterate.directions) {
                        state = state.func_196956_a(face, world.func_180495_p(targetPos.func_177972_a(face)), (IWorld)world, targetPos, targetPos.func_177972_a(face));
                    }
                }
                if ((blockState = world.func_180495_p(targetPos)).func_185887_b((IBlockReader)world, targetPos) == -1.0f || state.func_196952_d((IBlockReader)world, targetPos).func_197766_b() && !blockState.func_196952_d((IBlockReader)world, targetPos).func_197766_b()) {
                    if (targetPos.func_177956_o() == 0) {
                        targetPos = targetPos.func_177984_a();
                    }
                    world.func_217379_c(2001, targetPos, Block.func_196246_j((BlockState)state));
                    Block.func_220059_a((BlockState)state, (World)world, (BlockPos)targetPos, null);
                    continue;
                }
                if (state.func_177230_c() instanceof IWaterLoggable && state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
                    IFluidState ifluidstate = world.func_204610_c(targetPos);
                    state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
                }
                world.func_175655_b(targetPos, true);
                world.func_180501_a(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.func_176722_c();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.func_177230_c() instanceof PulleyBlock.RopeBlock || state.func_177230_c() instanceof PulleyBlock.MagnetBlock)) {
                    world.func_175655_b(targetPos, true);
                }
                TileEntity tileEntity = world.func_175625_s(targetPos);
                CompoundNBT tag = block.field_186244_c;
                if (tileEntity == null || tag == null) continue;
                tag.func_74768_a("x", targetPos.func_177958_n());
                tag.func_74768_a("y", targetPos.func_177956_o());
                tag.func_74768_a("z", targetPos.func_177952_p());
                if (verticalRotation && tileEntity instanceof PulleyTileEntity) {
                    tag.func_82580_o("Offset");
                    tag.func_82580_o("InitialOffset");
                }
                if (tileEntity instanceof FluidTankTileEntity && tag.func_74764_b("LastKnownPos")) {
                    tag.func_218657_a("LastKnownPos", (INBT)NBTUtil.func_186859_a((BlockPos)BlockPos.field_177992_a.func_177977_b()));
                }
                tileEntity.func_145839_a(tag);
                if (this.storage.containsKey(block.field_186242_a) && ((MountedStorage)(mountedStorage = this.storage.get(block.field_186242_a))).isValid()) {
                    ((MountedStorage)mountedStorage).addStorageToWorld(tileEntity);
                }
                if (!this.fluidStorage.containsKey(block.field_186242_a) || !((MountedFluidStorage)(mountedStorage = this.fluidStorage.get(block.field_186242_a))).isValid()) continue;
                ((MountedFluidStorage)mountedStorage).addStorageToWorld(tileEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            Template.BlockInfo block = (Template.BlockInfo)object.next();
            BlockPos targetPos = transform.apply(block.field_186242_a);
            world.markAndNotifyBlock(targetPos, null, block.field_186243_b, block.field_186243_b, 67);
        }
        for (i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInventory.getTanks(); ++i) {
            this.fluidInventory.drain(this.fluidInventory.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
        for (Pair<BlockPos, Direction> pair : this.superglue) {
            Direction targetFacing;
            BlockPos targetPos = transform.apply((BlockPos)pair.getKey());
            SuperGlueEntity entity = new SuperGlueEntity(world, targetPos, targetFacing = transform.transformFacing((Direction)pair.getValue()));
            if (!entity.onValidSurface() || world.field_72995_K) continue;
            world.func_217376_c((Entity)entity);
        }
    }

    public void addPassengersToWorld(World world, StructureTransform transform, List<Entity> seatedEntities) {
        for (Entity seatedEntity : seatedEntities) {
            if (this.getSeatMapping().isEmpty()) continue;
            Integer seatIndex = this.getSeatMapping().get(seatedEntity.func_110124_au());
            BlockPos seatPos = this.getSeats().get(seatIndex);
            if (!(world.func_180495_p(seatPos = transform.apply(seatPos)).func_177230_c() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(World world) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (Template.BlockInfo)pair.left, this);
            AllMovementBehaviours.of(((Template.BlockInfo)pair.left).field_186243_b).startMoving(context);
            pair.setRight((Object)context);
        }
    }

    public void stop(World world) {
        this.foreachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = Vec3d.field_186680_a;
            ctx.relativeMotion = Vec3d.field_186680_a;
            ctx.rotation = v -> v;
        });
    }

    public void foreachActor(World world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            callBack.accept(AllMovementBehaviours.of(((Template.BlockInfo)pair.getLeft()).field_186243_b), (MovementContext)pair.getRight());
        }
    }

    public void expandBoundsAroundAxis(Direction.Axis axis) {
        AxisAlignedBB bb = this.bounds;
        double maxXDiff = Math.max(bb.field_72336_d - 1.0, -bb.field_72340_a);
        double maxYDiff = Math.max(bb.field_72337_e - 1.0, -bb.field_72338_b);
        double maxZDiff = Math.max(bb.field_72334_f - 1.0, -bb.field_72339_c);
        double maxDiff = 0.0;
        if (axis == Direction.Axis.X) {
            maxDiff = Math.max(maxZDiff, maxYDiff);
        }
        if (axis == Direction.Axis.Y) {
            maxDiff = Math.max(maxZDiff, maxXDiff);
        }
        if (axis == Direction.Axis.Z) {
            maxDiff = Math.max(maxXDiff, maxYDiff);
        }
        Vec3d vec = new Vec3d(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176730_m());
        Vec3d planeByNormal = VecHelper.axisAlingedPlaneOf(vec);
        Vec3d min = vec.func_216372_d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_178787_e(planeByNormal.func_186678_a(-maxDiff));
        Vec3d max = vec.func_216372_d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_178787_e(planeByNormal.func_186678_a(maxDiff + 1.0));
        this.bounds = new AxisAlignedBB(min, max);
    }

    public void addExtraInventories(Entity entity) {
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public BlockPos getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public BlockPos getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<BlockPos> getSeats() {
        return this.seats;
    }

    public Map<BlockPos, Template.BlockInfo> getBlocks() {
        return this.blocks;
    }

    public List<MutablePair<Template.BlockInfo, MovementContext>> getActors() {
        return this.actors;
    }

    public void updateContainedFluid(BlockPos localPos, FluidStack containedFluid) {
        MountedFluidStorage mountedFluidStorage = this.fluidStorage.get(localPos);
        if (mountedFluidStorage != null) {
            mountedFluidStorage.updateFluid(containedFluid);
        }
    }
}

