/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ClientMotionPacket;
import com.simibubi.create.foundation.collision.ContinuousOBBCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OrientedBB;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class ContraptionCollider {
    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        World world = contraptionEntity.func_130014_f_();
        Contraption contraption = contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        Vec3d contraptionPosition = contraptionEntity.func_213303_ch();
        Vec3d contraptionMotion = contraptionPosition.func_178788_d(contraptionEntity.getPrevPositionVec());
        Vec3d anchorVec = contraptionEntity.getAnchorVec();
        Vec3d centerOfBlock = VecHelper.CENTER_OF_ORIGIN;
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        boolean skipClientPlayer = false;
        List entitiesWithinAABB = world.func_175647_a(Entity.class, bounds.func_186662_g(2.0).func_72321_a(0.0, 32.0, 0.0), contraptionEntity::canCollideWith);
        for (Entity entity : entitiesWithinAABB) {
            double d1;
            double idealVerticalMotion;
            PlayerType playerType = ContraptionCollider.getPlayerType(entity);
            if (playerType == PlayerType.REMOTE) continue;
            if (playerType == PlayerType.SERVER && entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.field_147365_f = 0;
                continue;
            }
            if (playerType == PlayerType.CLIENT) {
                if (skipClientPlayer) continue;
                skipClientPlayer = true;
            }
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            Vec3d entityPosition = entity.func_213303_ch();
            AxisAlignedBB entityBounds = entity.func_174813_aQ();
            Vec3d centerY = new Vec3d(0.0, entityBounds.func_216360_c() / 2.0, 0.0);
            Vec3d motion = entity.func_213322_ci();
            float yawOffset = rotation.getYawOffset();
            Vec3d position = entityPosition;
            position = position.func_178787_e(centerY);
            position = position.func_178788_d(centerOfBlock);
            position = position.func_178788_d(anchorVec);
            position = VecHelper.rotate(position, -yawOffset, Direction.Axis.Y);
            position = rotationMatrix.transform(position);
            position = position.func_178787_e(centerOfBlock);
            position = position.func_178788_d(centerY);
            AxisAlignedBB localBB = entityBounds.func_191194_a(position = position.func_178788_d(entityPosition)).func_186662_g(1.0E-7);
            ReuseableStream<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.func_216361_a(motion));
            if (potentialHits.func_212761_a().count() == 0L) continue;
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            motion = motion.func_178788_d(contraptionMotion);
            motion = rotationMatrix.transform(motion);
            MutableObject collisionResponse = new MutableObject((Object)Vec3d.field_186680_a);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            Vec3d obbCenter = obb.getCenter();
            ArrayList bbs = new ArrayList();
            potentialHits.func_212761_a().forEach(shape -> shape.func_197756_d().forEach(bbs::add));
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (AxisAlignedBB bb : bbs) {
                    double timeOfImpact;
                    Vec3d currentResponse = (Vec3d)collisionResponse.getValue();
                    obb.setCenter(obbCenter.func_178787_e(currentResponse));
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    if ((timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0) {
                        if (!((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                        temporalResponse.setValue((Number)timeOfImpact);
                        continue;
                    }
                    Vec3d separation = intersect.asSeparationVec(entity.field_70138_W);
                    if (separation == null || separation.equals((Object)Vec3d.field_186680_a)) continue;
                    collisionResponse.setValue((Object)currentResponse.func_178787_e(separation));
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((Vec3d)collisionResponse.getValue()).field_72448_b == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((Vec3d)collisionResponse.getValue()).func_216372_d(1.0078125, 0.0, 1.0078125));
            }
            Vec3d entityMotion = entity.func_213322_ci();
            Vec3d totalResponse = (Vec3d)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)Vec3d.field_186680_a);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            Vec3d motionResponse = !temporalCollision ? motion : motion.func_72432_b().func_186678_a(motion.func_72433_c() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).func_178787_e(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, Direction.Axis.Y);
            rotationMatrix.transpose();
            if (temporalCollision && (idealVerticalMotion = motionResponse.field_72448_b) != entityMotion.field_72448_b) {
                entity.func_213317_d(entityMotion.func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.func_213322_ci();
            }
            if (hardCollision) {
                double motionX = entityMotion.func_82615_a();
                double motionY = entityMotion.func_82617_b();
                double motionZ = entityMotion.func_82616_c();
                double intersectX = totalResponse.func_82615_a();
                double intersectY = totalResponse.func_82617_b();
                double intersectZ = totalResponse.func_82616_c();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.func_216372_d(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, contraptionMotion.field_72448_b, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.func_216372_d(1.0, 1.0, 0.0);
                }
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            Vec3d allowedMovement = ContraptionCollider.getAllowedMovement(totalResponse, entity);
            entity.func_70107_b(entityPosition.field_72450_a + allowedMovement.field_72450_a, entityPosition.field_72448_b + allowedMovement.field_72448_b, entityPosition.field_72449_c + allowedMovement.field_72449_c);
            entityPosition = entity.func_213303_ch();
            entity.field_70133_I = true;
            Vec3d contactPointMotion = Vec3d.field_186680_a;
            if (surfaceCollision.isTrue()) {
                entity.field_70143_R = 0.0f;
                entity.field_70122_E = true;
                contraptionEntity.collidingEntities.put(entity, new MutableInt(0));
                if (entity instanceof ItemEntity) {
                    entityMotion = entityMotion.func_216372_d(0.5, 1.0, 0.5);
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.getAllowedMovement(contactPointMotion, entity);
                entity.func_70107_b(entityPosition.field_72450_a + allowedMovement.field_72450_a, entityPosition.field_72448_b, entityPosition.field_72449_c + allowedMovement.field_72449_c);
            }
            entity.func_213317_d(entityMotion);
            if (playerType != PlayerType.CLIENT) continue;
            double d0 = entity.func_226277_ct_() - entity.field_70169_q - contactPointMotion.field_72450_a;
            float limbSwing = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = entity.func_226281_cx_() - entity.field_70166_s - contactPointMotion.field_72449_c) * d1)) * 4.0f;
            if (limbSwing > 1.0f) {
                limbSwing = 1.0f;
            }
            AllPackets.channel.sendToServer((Object)new ClientMotionPacket(entityMotion, true, limbSwing));
        }
    }

    static Vec3d getAllowedMovement(Vec3d movement, Entity e) {
        boolean flag3;
        AxisAlignedBB bb = e.func_174813_aQ();
        ISelectionContext ctx = ISelectionContext.func_216374_a((Entity)e);
        World world = e.field_70170_p;
        VoxelShape voxelshape = world.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)bb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = world.func_223439_a(e, bb.func_216361_a(movement), (Set)ImmutableSet.of());
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
        Vec3d vec3d = movement.func_189985_c() == 0.0 ? movement : Entity.func_223307_a((Entity)e, (Vec3d)movement, (AxisAlignedBB)bb, (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
        boolean flag = movement.field_72450_a != vec3d.field_72450_a;
        boolean flag1 = movement.field_72448_b != vec3d.field_72448_b;
        boolean flag2 = movement.field_72449_c != vec3d.field_72449_c;
        boolean bl = flag3 = e.field_70122_E || flag1 && movement.field_72448_b < 0.0;
        if (e.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vec3d vec3d3;
            Vec3d vec3d1 = Entity.func_223307_a((Entity)e, (Vec3d)new Vec3d(movement.field_72450_a, (double)e.field_70138_W, movement.field_72449_c), (AxisAlignedBB)bb, (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
            Vec3d vec3d2 = Entity.func_223307_a((Entity)e, (Vec3d)new Vec3d(0.0, (double)e.field_70138_W, 0.0), (AxisAlignedBB)bb.func_72321_a(movement.field_72450_a, 0.0, movement.field_72449_c), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
            if (vec3d2.field_72448_b < (double)e.field_70138_W && Entity.func_213296_b((Vec3d)(vec3d3 = Entity.func_223307_a((Entity)e, (Vec3d)new Vec3d(movement.field_72450_a, 0.0, movement.field_72449_c), (AxisAlignedBB)bb.func_191194_a(vec3d2), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream).func_178787_e(vec3d2))) > Entity.func_213296_b((Vec3d)vec3d1)) {
                vec3d1 = vec3d3;
            }
            if (Entity.func_213296_b((Vec3d)vec3d1) > Entity.func_213296_b((Vec3d)vec3d)) {
                return vec3d1.func_178787_e(Entity.func_223307_a((Entity)e, (Vec3d)new Vec3d(0.0, -vec3d1.field_72448_b + movement.field_72448_b, 0.0), (AxisAlignedBB)bb.func_191194_a(vec3d1), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream));
            }
        }
        return vec3d;
    }

    private static PlayerType getPlayerType(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return PlayerType.NONE;
        }
        if (!entity.field_70170_p.field_72995_K) {
            return PlayerType.SERVER;
        }
        MutableBoolean isClient = new MutableBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> isClient.setValue(ContraptionCollider.isClientPlayerEntity(entity)));
        return isClient.booleanValue() ? PlayerType.CLIENT : PlayerType.REMOTE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isClientPlayerEntity(Entity entity) {
        return entity instanceof ClientPlayerEntity;
    }

    private static ReuseableStream<VoxelShape> getPotentiallyCollidedShapes(World world, Contraption contraption, AxisAlignedBB localBB) {
        double width;
        double height = localBB.func_216360_c();
        double horizontalFactor = height > (width = localBB.func_216364_b()) && width != 0.0 ? height / width : 1.0;
        double verticalFactor = width > height && height != 0.0 ? width / height : 1.0;
        AxisAlignedBB blockScanBB = localBB.func_186662_g(0.5);
        blockScanBB = blockScanBB.func_72314_b(horizontalFactor, verticalFactor, horizontalFactor);
        BlockPos min = new BlockPos(blockScanBB.field_72340_a, blockScanBB.field_72338_b, blockScanBB.field_72339_c);
        BlockPos max = new BlockPos(blockScanBB.field_72336_d, blockScanBB.field_72337_e, blockScanBB.field_72334_f);
        ReuseableStream potentialHits = new ReuseableStream(BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).filter(contraption.getBlocks()::containsKey).map(p -> {
            BlockState blockState = contraption.getBlocks().get((Object)p).field_186243_b;
            BlockPos pos = contraption.getBlocks().get((Object)p).field_186242_a;
            VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)world, p);
            return collisionShape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }).filter((Predicate<VoxelShape>)Predicates.not(VoxelShape::func_197766_b)));
        return potentialHits;
    }

    public static boolean collideBlocks(ControlledContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision()) {
            return false;
        }
        World world = contraptionEntity.func_130014_f_();
        Vec3d motion = contraptionEntity.func_213322_ci();
        TranslatingContraption contraption = (TranslatingContraption)contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        Vec3d position = contraptionEntity.func_213303_ch();
        BlockPos gridPos = new BlockPos(position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3d.field_186680_a)) {
            return false;
        }
        Direction movementDirection = Direction.func_210769_a((double)motion.field_72450_a, (double)motion.field_72448_b, (double)motion.field_72449_c);
        if (movementDirection.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.func_177972_a(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : world.func_175647_a(ControlledContraptionEntity.class, bounds.func_186662_g(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vec3d otherMotion = otherContraptionEntity.func_213322_ci();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AxisAlignedBB otherBounds = otherContraptionEntity.func_174813_aQ();
            Vec3d otherPosition = otherContraptionEntity.func_213303_ch();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.func_191194_a(motion).func_72326_a(otherBounds.func_191194_a(otherMotion))) continue;
            for (BlockPos colliderPos : contraption.getColliders(world, movementDirection)) {
                colliderPos = colliderPos.func_177971_a((Vec3i)gridPos).func_177973_b((Vec3i)new BlockPos(otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(World world, TranslatingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getColliders(world, movementDirection)) {
            BlockBreakingMovementBehaviour behaviour;
            MovementBehaviour movementBehaviour;
            BlockPos colliderPos = pos.func_177971_a((Vec3i)anchor);
            if (!world.func_195588_v(colliderPos)) {
                return true;
            }
            BlockState collidedState = world.func_180495_p(colliderPos);
            Template.BlockInfo blockInfo = contraption.getBlocks().get(pos);
            if (!(AllMovementBehaviours.contains(blockInfo.field_186243_b.func_177230_c()) && (movementBehaviour = AllMovementBehaviours.of(blockInfo.field_186243_b.func_177230_c())) instanceof BlockBreakingMovementBehaviour ? !(behaviour = (BlockBreakingMovementBehaviour)movementBehaviour).canBreak(world, colliderPos, collidedState) && !collidedState.func_196952_d((IBlockReader)world, pos).func_197766_b() : (!AllBlocks.PULLEY_MAGNET.has(collidedState) || !pos.equals((Object)BlockPos.field_177992_a) || movementDirection != Direction.UP) && !(collidedState.func_177230_c() instanceof CocoaBlock) && !collidedState.func_185904_a().func_76222_j() && !collidedState.func_196952_d((IBlockReader)world, colliderPos).func_197766_b())) continue;
            return true;
        }
        return false;
    }

    static enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER;

    }
}

