/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ContraptionInteractionPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber
public class ContraptionHandlerClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void preventRemotePlayersWalkingAnimations(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!(event.player instanceof RemoteClientPlayerEntity)) {
            return;
        }
        RemoteClientPlayerEntity remotePlayer = (RemoteClientPlayerEntity)event.player;
        CompoundNBT data = remotePlayer.getPersistentData();
        if (!data.func_74764_b("LastOverrideLimbSwingUpdate")) {
            return;
        }
        int lastOverride = data.func_74762_e("LastOverrideLimbSwingUpdate");
        data.func_74768_a("LastOverrideLimbSwingUpdate", lastOverride + 1);
        if (lastOverride > 5) {
            data.func_82580_o("LastOverrideLimbSwingUpdate");
            data.func_82580_o("OverrideLimbSwing");
            return;
        }
        float limbSwing = data.func_74760_g("OverrideLimbSwing");
        remotePlayer.field_70169_q = remotePlayer.func_226277_ct_() - (double)(limbSwing / 4.0f);
        remotePlayer.field_70166_s = remotePlayer.func_226281_cx_();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void rightClickingOnContraptionsGetsHandledLocally(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (mc.field_71441_e == null) {
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        Vec3d origin = RaycastHelper.getTraceOrigin((PlayerEntity)player);
        double reach = mc.field_71442_b.func_78757_d();
        if (mc.field_71476_x != null && mc.field_71476_x.func_216347_e() != null) {
            reach = Math.min(mc.field_71476_x.func_216347_e().func_72438_d(origin), reach);
        }
        Vec3d target = RaycastHelper.getTraceTarget((PlayerEntity)player, reach, origin);
        for (AbstractContraptionEntity contraptionEntity : mc.field_71441_e.func_217357_a(AbstractContraptionEntity.class, new AxisAlignedBB(origin, target))) {
            MutableObject mutableResult;
            Contraption contraption;
            Vec3d localTarget;
            Vec3d localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
            RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(localOrigin, localTarget = contraptionEntity.toLocalVector(target, 1.0f), arg_0 -> ContraptionHandlerClient.lambda$rightClickingOnContraptionsGetsHandledLocally$0(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, mutableResult = new MutableObject(), arg_0));
            if (predicateResult == null || predicateResult.missed()) {
                return;
            }
            BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)mutableResult.getValue();
            Hand hand = event.getHand();
            Direction face = rayTraceResult.func_216354_b();
            BlockPos pos = rayTraceResult.func_216350_a();
            if (!contraptionEntity.handlePlayerInteraction((PlayerEntity)player, pos, face, hand)) {
                return;
            }
            AllPackets.channel.sendToServer((Object)new ContraptionInteractionPacket(contraptionEntity, hand, pos, face));
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    private static /* synthetic */ boolean lambda$rightClickingOnContraptionsGetsHandledLocally$0(Contraption contraption, Vec3d localOrigin, Vec3d localTarget, MutableObject mutableResult, BlockPos p) {
        Template.BlockInfo blockInfo = contraption.getBlocks().get(p);
        if (blockInfo == null) {
            return false;
        }
        BlockState state = blockInfo.field_186243_b;
        VoxelShape raytraceShape = state.func_196954_c((IBlockReader)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a.func_177977_b());
        if (raytraceShape.func_197766_b()) {
            return false;
        }
        BlockRayTraceResult rayTrace = raytraceShape.func_212433_a(localOrigin, localTarget, p);
        if (rayTrace != null) {
            mutableResult.setValue((Object)rayTrace);
            return true;
        }
        return false;
    }
}

