/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public abstract class TranslatingContraption
extends Contraption {
    protected Set<BlockPos> cachedColliders;
    protected Direction cachedColliderDirection;

    public Set<BlockPos> getColliders(World world, Direction movementDirection) {
        if (this.getBlocks() == null) {
            return Collections.EMPTY_SET;
        }
        if (this.cachedColliders == null || this.cachedColliderDirection != movementDirection) {
            this.cachedColliders = new HashSet<BlockPos>();
            this.cachedColliderDirection = movementDirection;
            for (Template.BlockInfo info : this.getBlocks().values()) {
                BlockPos offsetPos = info.field_186242_a.func_177972_a(movementDirection);
                if (info.field_186243_b.func_196952_d((IBlockReader)world, offsetPos).func_197766_b() || this.getBlocks().containsKey(offsetPos) && !this.getBlocks().get((Object)offsetPos).field_186243_b.func_196952_d((IBlockReader)world, offsetPos).func_197766_b()) continue;
                this.cachedColliders.add(info.field_186242_a);
            }
        }
        return this.cachedColliders;
    }

    @Override
    public void removeBlocksFromWorld(World world, BlockPos offset) {
        int count = this.blocks.size();
        super.removeBlocksFromWorld(world, offset);
        if (count != this.blocks.size()) {
            this.cachedColliders = null;
        }
    }

    @Override
    protected boolean canAxisBeStabilized(Direction.Axis axis) {
        return false;
    }
}

