/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssembleRailType;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.content.contraptions.components.tracks.ControllerRailBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.util.LazyOptional;

public class CartAssemblerBlock
extends AbstractRailBlock
implements ITE<CartAssemblerTileEntity>,
IWrenchable,
ISpecialBlockItemRequirement {
    public static final IProperty<RailShape> RAIL_SHAPE = EnumProperty.func_177706_a((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.EAST_WEST, RailShape.NORTH_SOUTH});
    public static final IProperty<CartAssembleRailType> RAIL_TYPE = EnumProperty.func_177709_a((String)"rail_type", CartAssembleRailType.class);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public CartAssemblerBlock(Block.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(RAIL_TYPE, (Comparable)((Object)CartAssembleRailType.POWERED_RAIL)));
    }

    public static BlockState createAnchor(BlockState state) {
        Direction.Axis axis = state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)axis);
    }

    private static Item getRailItem(BlockState state) {
        return ((CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE))).getItem();
    }

    public static BlockState getRailBlock(BlockState state) {
        AbstractRailBlock railBlock = (AbstractRailBlock)((CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE))).getBlock();
        BlockState railState = (BlockState)railBlock.func_176223_P().func_206870_a(railBlock.func_176560_l(), state.func_177229_b(RAIL_SHAPE));
        if (railState.func_196959_b((IProperty)ControllerRailBlock.BACKWARDS)) {
            railState = (BlockState)railState.func_206870_a((IProperty)ControllerRailBlock.BACKWARDS, (Comparable)Boolean.valueOf(state.func_177229_b(RAIL_TYPE) == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS));
        }
        return railState;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{RAIL_SHAPE, POWERED, RAIL_TYPE});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CART_ASSEMBLER.create();
    }

    public boolean canMakeSlopes(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return false;
    }

    public void onMinecartPass(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, AbstractMinecartEntity cart) {
        if (!CartAssemblerBlock.canAssembleTo(cart)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            float speed;
            if (!te.isMinecartUpdateValid()) {
                return;
            }
            CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
            if (action.shouldAssemble()) {
                this.assemble(world, pos, cart);
            }
            if (action.shouldDisassemble()) {
                this.disassemble(world, pos, cart);
            }
            if (action == CartAssemblerAction.ASSEMBLE_ACCELERATE) {
                Direction facing = cart.func_184172_bi();
                speed = this.getRailMaxSpeed(state, world, pos, cart);
                cart.func_213293_j((double)((float)facing.func_82601_c() * speed), (double)((float)facing.func_96559_d() * speed), (double)((float)facing.func_82599_e() * speed));
            }
            if (action == CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
                Vec3i accelerationVector = ControllerRailBlock.getAccelerationVector((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().func_206870_a(ControllerRailBlock.SHAPE, state.func_177229_b(RAIL_SHAPE))).func_206870_a((IProperty)ControllerRailBlock.BACKWARDS, (Comparable)Boolean.valueOf(state.func_177229_b(RAIL_TYPE) == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS)));
                speed = this.getRailMaxSpeed(state, world, pos, cart);
                cart.func_213317_d(new Vec3d(accelerationVector).func_186678_a((double)speed));
            }
            if (action == CartAssemblerAction.DISASSEMBLE_BRAKE) {
                Vec3d diff = VecHelper.getCenterOf((Vec3i)pos).func_178788_d(cart.func_213303_ch());
                cart.func_213293_j(diff.field_72450_a / 16.0, 0.0, diff.field_72449_c / 16.0);
            }
        });
    }

    public static CartAssemblerAction getActionForCart(BlockState state, AbstractMinecartEntity cart) {
        CartAssembleRailType type = (CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE));
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (type == CartAssembleRailType.REGULAR) {
            return powered ? CartAssemblerAction.ASSEMBLE : CartAssemblerAction.DISASSEMBLE;
        }
        if (type == CartAssembleRailType.ACTIVATOR_RAIL) {
            return powered ? CartAssemblerAction.DISASSEMBLE : CartAssemblerAction.PASS;
        }
        if (type == CartAssembleRailType.POWERED_RAIL) {
            return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE_BRAKE;
        }
        if (type == CartAssembleRailType.DETECTOR_RAIL) {
            return cart.func_184188_bt().isEmpty() ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE;
        }
        if (type == CartAssembleRailType.CONTROLLER_RAIL || type == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS) {
            return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL : CartAssemblerAction.DISASSEMBLE_BRAKE;
        }
        return CartAssemblerAction.PASS;
    }

    public static boolean canAssembleTo(AbstractMinecartEntity cart) {
        return cart.canBeRidden() || cart instanceof FurnaceMinecartEntity || cart instanceof ChestMinecartEntity;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult blockRayTraceResult) {
        ItemStack itemStack = player.func_184586_b(hand);
        Item previousItem = CartAssemblerBlock.getRailItem(state);
        Item heldItem = itemStack.func_77973_b();
        if (heldItem != previousItem) {
            CartAssembleRailType newType = null;
            for (CartAssembleRailType type : CartAssembleRailType.values()) {
                if (heldItem != type.getItem()) continue;
                newType = type;
            }
            if (newType == null) {
                return ActionResultType.PASS;
            }
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_175656_a(pos, (BlockState)state.func_206870_a(RAIL_TYPE, (Comparable)((Object)newType)));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                player.field_71071_by.func_191975_a(world, new ItemStack((IItemProvider)previousItem));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void assemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        Optional<Direction> initialOrientation;
        if (!cart.func_184188_bt().isEmpty()) {
            return;
        }
        LazyOptional optional = cart.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (optional.isPresent() && ((MinecartController)optional.orElse(null)).isCoupledThroughContraption()) {
            return;
        }
        CartAssemblerTileEntity.CartMovementMode mode = this.getTileEntityOptional((IBlockReader)world, pos).map(te -> CartAssemblerTileEntity.CartMovementMode.values()[te.movementMode.value]).orElse(CartAssemblerTileEntity.CartMovementMode.ROTATE);
        MountedContraption contraption = new MountedContraption(mode);
        if (!contraption.assemble(world, pos)) {
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        Optional<Direction> optional2 = initialOrientation = cart.func_213322_ci().func_72433_c() < 0.001953125 ? Optional.empty() : Optional.of(cart.func_184172_bi());
        if (couplingFound) {
            cart.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.func_145782_y(), contraption.connectedCart.func_145782_y())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, BlockPos.field_177992_a);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        if (couplingFound) {
            Vec3d diff = contraption.connectedCart.func_213303_ch().func_178788_d(cart.func_213303_ch());
            initialOrientation = Optional.of(Direction.func_176733_a((double)(MathHelper.func_181159_b((double)diff.field_72449_c, (double)diff.field_72450_a) * 180.0 / Math.PI)));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.func_110124_au());
        }
        entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        world.func_217376_c((Entity)entity);
        entity.func_184220_m((Entity)cart);
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", 0.0);
            nbt.func_74780_a("PushX", 0.0);
            cart.deserializeNBT(nbt);
        }
    }

    protected void disassemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (cart.func_184188_bt().isEmpty()) {
            return;
        }
        Entity entity = (Entity)cart.func_184188_bt().get(0);
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            BlockPos otherPos = minecartController.cart().func_180425_c();
            BlockState blockState = world.func_180495_p(otherPos);
            if (!AllBlocks.CART_ASSEMBLER.has(blockState)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(AbstractMinecartEntity cart) {
        cart.func_184226_ay();
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", cart.func_213322_ci().field_72450_a);
            nbt.func_74780_a("PushX", cart.func_213322_ci().field_72449_c);
            cart.deserializeNBT(nbt);
        }
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    @Nonnull
    public IProperty<RailShape> func_176560_l() {
        return RAIL_SHAPE;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return AllShapes.CART_ASSEMBLER.get(this.getRailAxis(state));
    }

    protected Direction.Axis getRailAxis(BlockState state) {
        return state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity instanceof AbstractMinecartEntity) {
            return VoxelShapes.func_197880_a();
        }
        if (entity instanceof PlayerEntity) {
            return AllShapes.CART_ASSEMBLER_PLAYER_COLLISION.get(this.getRailAxis(state));
        }
        return VoxelShapes.func_197868_b();
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_220081_d(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public Class<CartAssemblerTileEntity> getTileEntityClass() {
        return CartAssemblerTileEntity.class;
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.addAll(CartAssemblerBlock.getRailBlock(state).func_215693_a(builder));
        return drops;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        ArrayList<ItemStack> reuiredItems = new ArrayList<ItemStack>();
        reuiredItems.add(new ItemStack((IItemProvider)CartAssemblerBlock.getRailItem(state)));
        reuiredItems.add(new ItemStack((IItemProvider)this.func_199767_j()));
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, reuiredItems);
    }

    public List<ItemStack> getDropedAssembler(BlockState p_220077_0_, ServerWorld p_220077_1_, BlockPos p_220077_2_, @Nullable TileEntity p_220077_3_, @Nullable Entity p_220077_4_, ItemStack p_220077_5_) {
        return super.func_220076_a(p_220077_0_, new LootContext.Builder(p_220077_1_).func_216023_a(p_220077_1_.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)p_220077_2_).func_216015_a(LootParameters.field_216289_i, (Object)p_220077_5_).func_216021_b(LootParameters.field_216281_a, (Object)p_220077_4_).func_216021_b(LootParameters.field_216288_h, (Object)p_220077_3_));
    }

    @Override
    public ActionResultType onSneakWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player != null && !player.func_184812_l_()) {
            this.getDropedAssembler(state, (ServerWorld)world, pos, world.func_175625_s(pos), (Entity)player, context.func_195996_i()).forEach(itemStack -> player.field_71071_by.func_191975_a(world, itemStack));
        }
        state.func_215706_a(world, pos, ItemStack.field_190927_a);
        world.func_175656_a(pos, CartAssemblerBlock.getRailBlock(state));
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos pos = context.func_195995_a();
        BlockState newState = (BlockState)state.func_206870_a(RAIL_SHAPE, (Comparable)(state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH));
        if (state.func_177229_b(RAIL_TYPE) == CartAssembleRailType.CONTROLLER_RAIL || state.func_177229_b(RAIL_TYPE) == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS) {
            newState = (BlockState)newState.func_206870_a(RAIL_TYPE, (Comparable)((Object)((Boolean)((ControllerRailBlock)AllBlocks.CONTROLLER_RAIL.get()).func_185499_a((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().func_206870_a(ControllerRailBlock.SHAPE, state.func_177229_b(RAIL_SHAPE))).func_206870_a((IProperty)ControllerRailBlock.BACKWARDS, (Comparable)Boolean.valueOf(state.func_177229_b(RAIL_TYPE) == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS)), Rotation.CLOCKWISE_90).func_177229_b((IProperty)ControllerRailBlock.BACKWARDS) != false ? CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS : CartAssembleRailType.CONTROLLER_RAIL)));
        }
        context.func_195991_k().func_180501_a(pos, newState, 3);
        world.func_195593_d(pos.func_177977_b(), (Block)this);
        return ActionResultType.SUCCESS;
    }

    public static class MinecartAnchorBlock
    extends Block {
        public MinecartAnchorBlock(Block.Properties p_i48440_1_) {
            super(p_i48440_1_);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208199_z});
            super.func_206840_a(builder);
        }

        @Nonnull
        public VoxelShape func_220053_a(@Nonnull BlockState p_220053_1_, @Nonnull IBlockReader p_220053_2_, @Nonnull BlockPos p_220053_3_, @Nonnull ISelectionContext p_220053_4_) {
            return VoxelShapes.func_197880_a();
        }
    }

    public static enum CartAssemblerAction {
        ASSEMBLE,
        DISASSEMBLE,
        ASSEMBLE_ACCELERATE,
        DISASSEMBLE_BRAKE,
        ASSEMBLE_ACCELERATE_DIRECTIONAL,
        PASS;


        public boolean shouldAssemble() {
            return this == ASSEMBLE || this == ASSEMBLE_ACCELERATE || this == ASSEMBLE_ACCELERATE_DIRECTIONAL;
        }

        public boolean shouldDisassemble() {
            return this == DISASSEMBLE || this == DISASSEMBLE_BRAKE;
        }
    }
}

