/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperDirectionalBlock;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PistonExtensionPoleBlock
extends ProperDirectionalBlock
implements IWrenchable,
IWaterLoggable {
    private static final int placementHelperId = PlacementHelpers.register(PlacementHelper.get());

    public PistonExtensionPoleBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)Direction.UP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction.Axis axis = ((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176740_k();
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        BlockPos pistonHead = null;
        BlockPos pistonBase = null;
        int[] nArray = new int[]{1, -1};
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int modifier;
            int offset = modifier = nArray[i];
            while (modifier * offset < MechanicalPistonBlock.maxAllowedPistonPoles()) {
                BlockPos currentPos = pos.func_177967_a(direction, offset);
                BlockState block = worldIn.func_180495_p(currentPos);
                if (!MechanicalPistonBlock.isExtensionPole(block) || axis != ((Direction)block.func_177229_b((IProperty)field_176387_N)).func_176740_k()) {
                    if (MechanicalPistonBlock.isPiston(block) && ((Direction)block.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k() == axis) {
                        pistonBase = currentPos;
                    }
                    if (!MechanicalPistonBlock.isPistonHead(block) || ((Direction)block.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k() != axis) continue block0;
                    pistonHead = currentPos;
                    continue block0;
                }
                offset += modifier;
            }
        }
        if (pistonHead != null && pistonBase != null && worldIn.func_180495_p(pistonHead).func_177229_b((IProperty)BlockStateProperties.field_208155_H) == worldIn.func_180495_p(pistonBase).func_177229_b((IProperty)BlockStateProperties.field_208155_H)) {
            BlockPos basePos = pistonBase;
            BlockPos.func_218281_b(pistonBase, pistonHead).filter(p -> !p.equals((Object)pos) && !p.equals((Object)basePos)).forEach(p -> worldIn.func_175655_b(p, !player.func_184812_l_()));
            worldIn.func_175656_a(basePos, (BlockState)worldIn.func_180495_p(basePos).func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.FOUR_VOXEL_POLE.get(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176740_k());
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (AllBlocks.PISTON_EXTENSION_POLE.isIn(heldItem) && !player.func_225608_bj_()) {
            IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
            PlacementOffset offset = placementHelper.getOffset(world, state, pos, ray);
            if (!offset.isReplaceable(world)) {
                return ActionResultType.PASS;
            }
            offset.placeInWorld(world, AllBlocks.PISTON_EXTENSION_POLE.getDefaultState(), player, heldItem);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208198_y});
        super.func_206840_a(builder);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    @MethodsReturnNonnullByDefault
    public static class PlacementHelper
    extends PoleHelper<Direction> {
        private static final PlacementHelper instance = new PlacementHelper();

        public static PlacementHelper get() {
            return instance;
        }

        private PlacementHelper() {
            super(AllBlocks.PISTON_EXTENSION_POLE::has, state -> ((Direction)state.func_177229_b((IProperty)DirectionalBlock.field_176387_N)).func_176740_k(), DirectionalBlock.field_176387_N);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.PISTON_EXTENSION_POLE::isIn;
        }
    }
}

