/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.sync;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class LimbSwingUpdatePacket
extends SimplePacketBase {
    private int entityId;
    private Vec3d position;
    private float limbSwing;

    public LimbSwingUpdatePacket(int entityId, Vec3d position, float limbSwing) {
        this.entityId = entityId;
        this.position = position;
        this.limbSwing = limbSwing;
    }

    public LimbSwingUpdatePacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.position = new Vec3d((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat());
        this.limbSwing = buffer.readFloat();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeFloat((float)this.position.field_72450_a);
        buffer.writeFloat((float)this.position.field_72448_b);
        buffer.writeFloat((float)this.position.field_72449_c);
        buffer.writeFloat(this.limbSwing);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            Entity entity = world.func_73045_a(this.entityId);
            if (entity == null) {
                return;
            }
            CompoundNBT data = entity.getPersistentData();
            data.func_74768_a("LastOverrideLimbSwingUpdate", 0);
            data.func_74776_a("OverrideLimbSwing", this.limbSwing);
            entity.func_180426_a(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c, entity.field_70177_z, entity.field_70125_A, 2, false);
        });
        context.get().setPacketHandled(true);
    }
}

