/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CouplingHandler {
    @SubscribeEvent
    public static void preventEntitiesFromMoutingOccupiedCart(EntityMountEvent event) {
        Entity e = event.getEntityBeingMounted();
        LazyOptional optional = e.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (!optional.isPresent()) {
            return;
        }
        if (event.getEntityMounting() instanceof AbstractContraptionEntity) {
            return;
        }
        MinecartController controller = (MinecartController)optional.orElse(null);
        if (controller.isCoupledThroughContraption()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    public static void forEachLoadedCoupling(World world, Consumer<Couple<MinecartController>> consumer) {
        if (world == null) {
            return;
        }
        Set<UUID> cartsWithCoupling = CapabilityMinecartController.loadedMinecartsWithCoupling.get((IWorld)world);
        if (cartsWithCoupling == null) {
            return;
        }
        cartsWithCoupling.forEach(id -> {
            MinecartController controller = CapabilityMinecartController.getIfPresent(world, id);
            if (controller == null) {
                return;
            }
            if (!controller.isLeadingCoupling()) {
                return;
            }
            UUID coupledCart = controller.getCoupledCart(true);
            MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
            if (coupledController == null) {
                return;
            }
            consumer.accept(Couple.create(controller, coupledController));
        });
    }

    public static boolean tryToCoupleCarts(@Nullable PlayerEntity player, World world, int cartId1, int cartId2) {
        boolean contraptionCoupling;
        Entity entity1 = world.func_73045_a(cartId1);
        Entity entity2 = world.func_73045_a(cartId2);
        if (!(entity1 instanceof AbstractMinecartEntity)) {
            return false;
        }
        if (!(entity2 instanceof AbstractMinecartEntity)) {
            return false;
        }
        String tooMany = "two_couplings_max";
        String unloaded = "unloaded";
        String noLoops = "no_loops";
        String tooFar = "too_far";
        int distanceTo = (int)entity1.func_213303_ch().func_72438_d(entity2.func_213303_ch());
        boolean bl = contraptionCoupling = player == null;
        if (distanceTo < 2) {
            if (contraptionCoupling) {
                return false;
            }
            distanceTo = 2;
        }
        if (distanceTo > (Integer)AllConfigs.SERVER.kinetics.maxCartCouplingLength.get()) {
            CouplingHandler.status(player, tooFar);
            return false;
        }
        AbstractMinecartEntity cart1 = (AbstractMinecartEntity)entity1;
        AbstractMinecartEntity cart2 = (AbstractMinecartEntity)entity2;
        UUID mainID = cart1.func_110124_au();
        UUID connectedID = cart2.func_110124_au();
        MinecartController mainController = CapabilityMinecartController.getIfPresent(world, mainID);
        MinecartController connectedController = CapabilityMinecartController.getIfPresent(world, connectedID);
        if (mainController == null || connectedController == null) {
            CouplingHandler.status(player, unloaded);
            return false;
        }
        if (mainController.isFullyCoupled() || connectedController.isFullyCoupled()) {
            CouplingHandler.status(player, tooMany);
            return false;
        }
        if (mainController.isLeadingCoupling() && mainController.getCoupledCart(true).equals(connectedID) || connectedController.isLeadingCoupling() && connectedController.getCoupledCart(true).equals(mainID)) {
            return false;
        }
        for (boolean main : Iterate.trueAndFalse) {
            MinecartController current = main ? mainController : connectedController;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.logger.warn("Infinite loop in coupling iteration");
                    return false;
                }
                if ((current = CouplingHandler.getNextInCouplingChain(world, current, forward)) == null) {
                    CouplingHandler.status(player, unloaded);
                    return false;
                }
                if (current != connectedController) continue;
                CouplingHandler.status(player, noLoops);
                return false;
            } while (current != MinecartController.EMPTY);
        }
        if (!contraptionCoupling) {
            for (Hand hand : Hand.values()) {
                if (player.func_184812_l_()) break;
                ItemStack heldItem = player.func_184586_b(hand);
                if (!AllItems.MINECART_COUPLING.isIn(heldItem)) continue;
                heldItem.func_190918_g(1);
                break;
            }
        }
        mainController.prepareForCoupling(true);
        connectedController.prepareForCoupling(false);
        mainController.coupleWith(true, connectedID, distanceTo, contraptionCoupling);
        connectedController.coupleWith(false, mainID, distanceTo, contraptionCoupling);
        return true;
    }

    @Nullable
    public static MinecartController getNextInCouplingChain(World world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return MinecartController.empty();
        }
        return CapabilityMinecartController.getIfPresent(world, coupledCart);
    }

    public static void status(PlayerEntity player, String key) {
        if (player == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new StringTextComponent(Lang.translate("minecart_coupling." + key, new Object[0])), true);
    }
}

