/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.MinecartSim2020;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;

public class CouplingPhysics {
    public static void tick(World world) {
        CouplingHandler.forEachLoadedCoupling(world, c -> CouplingPhysics.tickCoupling(world, c));
    }

    public static void tickCoupling(World world, Couple<MinecartController> c) {
        Couple<AbstractMinecartEntity> carts = c.map(MinecartController::cart);
        float couplingLength = ((MinecartController)c.getFirst()).getCouplingLength(true);
        CouplingPhysics.softCollisionStep(world, carts, couplingLength);
        if (world.field_72995_K) {
            return;
        }
        CouplingPhysics.hardCollisionStep(world, carts, couplingLength);
    }

    public static void hardCollisionStep(World world, Couple<AbstractMinecartEntity> carts, double couplingLength) {
        if (!MinecartSim2020.canAddMotion(((Couple)carts).get(false)) && MinecartSim2020.canAddMotion(((Couple)carts).get(true))) {
            carts = ((Couple)carts).swap();
        }
        Couple<Object> corrections = Couple.create(null, null);
        Couple<Float> maxSpeed = ((Couple)carts).map(IForgeEntityMinecart::getMaxCartSpeedOnRail);
        boolean firstLoop = true;
        for (boolean current : new boolean[]{true, false, true}) {
            float correctionMagnitude;
            AbstractMinecartEntity cart = (AbstractMinecartEntity)((Couple)carts).get(current);
            AbstractMinecartEntity otherCart = (AbstractMinecartEntity)((Couple)carts).get(!current);
            float stress = (float)(couplingLength - cart.func_213303_ch().func_72438_d(otherCart.func_213303_ch()));
            if (Math.abs(stress) < 0.125f) continue;
            RailShape shape = null;
            BlockPos railPosition = cart.getCurrentRailPosition();
            BlockState railState = world.func_180495_p(railPosition.func_177984_a());
            if (railState.func_177230_c() instanceof AbstractRailBlock) {
                AbstractRailBlock block = (AbstractRailBlock)railState.func_177230_c();
                shape = block.getRailDirection(railState, (IBlockReader)world, railPosition, cart);
            }
            Vec3d correction = Vec3d.field_186680_a;
            Vec3d pos = cart.func_213303_ch();
            Vec3d link = otherCart.func_213303_ch().func_178788_d(pos);
            float f = correctionMagnitude = firstLoop ? -stress / 2.0f : -stress;
            if (!MinecartSim2020.canAddMotion(cart)) {
                correctionMagnitude /= 2.0f;
            }
            correction = shape != null ? CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, MinecartSim2020.getRailVec(shape)).func_178788_d(pos) : link.func_72432_b().func_186678_a((double)correctionMagnitude);
            float maxResolveSpeed = 1.75f;
            correction = VecHelper.clamp(correction, Math.min(maxResolveSpeed, maxSpeed.get(current).floatValue()));
            if (corrections.get(current) == null) {
                corrections.set(current, correction);
            }
            if (shape != null) {
                MinecartSim2020.moveCartAlongTrack(cart, correction, railPosition, railState);
            } else {
                cart.func_213315_a(MoverType.SELF, correction);
                cart.func_213317_d(cart.func_213322_ci().func_186678_a(0.5));
            }
            firstLoop = false;
        }
    }

    public static void softCollisionStep(World world, Couple<AbstractMinecartEntity> carts, double couplingLength) {
        Couple<Float> maxSpeed = carts.map(IForgeEntityMinecart::getMaxCartSpeedOnRail);
        Couple<Boolean> canAddmotion = carts.map(MinecartSim2020::canAddMotion);
        Couple<Vec3d> motions = carts.map(Entity::func_213322_ci);
        Couple<Vec3d> nextPositions = carts.map(MinecartSim2020::predictNextPositionOf);
        Couple<RailShape> shapes = carts.mapWithContext((cart, current) -> {
            BlockPos railPosition;
            BlockState railState;
            int z;
            int y;
            AbstractMinecartEntity minecart = cart.getMinecart();
            Vec3d vec = (Vec3d)nextPositions.get((boolean)current);
            int x = MathHelper.func_76128_c((double)vec.func_82615_a());
            BlockPos pos = new BlockPos(x, (y = MathHelper.func_76128_c((double)vec.func_82617_b())) - 1, z = MathHelper.func_76128_c((double)vec.func_82616_c()));
            if (minecart.field_70170_p.func_180495_p(pos).func_203425_a(BlockTags.field_203437_y)) {
                pos = pos.func_177977_b();
            }
            if (!((railState = world.func_180495_p((railPosition = pos).func_177984_a())).func_177230_c() instanceof AbstractRailBlock)) {
                return null;
            }
            AbstractRailBlock block = (AbstractRailBlock)railState.func_177230_c();
            return block.getRailDirection(railState, (IBlockReader)world, railPosition, cart);
        });
        float futureStress = (float)(couplingLength - ((Vec3d)nextPositions.getFirst()).func_72438_d((Vec3d)nextPositions.getSecond()));
        if (MathHelper.func_219806_b((double)futureStress, (double)0.0)) {
            return;
        }
        for (boolean current2 : Iterate.trueAndFalse) {
            Vec3d correction = Vec3d.field_186680_a;
            Vec3d pos = nextPositions.get(current2);
            Vec3d link = nextPositions.get(!current2).func_178788_d(pos);
            float correctionMagnitude = -futureStress / 2.0f;
            if (canAddmotion.get(current2) != canAddmotion.get(!current2)) {
                float f = correctionMagnitude = canAddmotion.get(current2) == false ? 0.0f : correctionMagnitude * 2.0f;
            }
            if (!canAddmotion.get(current2).booleanValue()) continue;
            RailShape shape = shapes.get(current2);
            if (shape != null) {
                Vec3d railVec = MinecartSim2020.getRailVec(shape);
                correction = CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, railVec).func_178788_d(pos);
            } else {
                correction = link.func_72432_b().func_186678_a((double)correctionMagnitude);
            }
            correction = VecHelper.clamp(correction, maxSpeed.get(current2).floatValue());
            motions.set(current2, motions.get(current2).func_178787_e(correction));
        }
        motions.replaceWithParams(VecHelper::clamp, maxSpeed);
        carts.forEachWithParams(Entity::func_213317_d, motions);
    }

    public static Vec3d followLinkOnRail(Vec3d link, Vec3d cart, float diffToReduce, Vec3d railAxis) {
        double radius;
        Vec3d center;
        double dotProduct = railAxis.func_72430_b(link);
        if (Double.isNaN(dotProduct) || dotProduct == 0.0 || diffToReduce == 0.0f) {
            return cart;
        }
        Vec3d axis = railAxis.func_186678_a(-Math.signum(dotProduct));
        Vec3d intersectSphere = VecHelper.intersectSphere(cart, axis, center = cart.func_178787_e(link), radius = link.func_72433_c() - (double)diffToReduce);
        if (intersectSphere == null) {
            return cart.func_178787_e(VecHelper.project(link, axis));
        }
        return intersectSphere;
    }
}

