/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class WaterWheelTileEntity
extends GeneratingKineticTileEntity {
    private Map<Direction, Float> flows = new HashMap<Direction, Float>();

    public WaterWheelTileEntity(TileEntityType<? extends WaterWheelTileEntity> type) {
        super(type);
        for (Direction d : Iterate.directions) {
            this.setFlow(d, 0.0f);
        }
        this.setLazyTickRate(20);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.func_74764_b("Flows")) {
            for (Direction d : Iterate.directions) {
                this.setFlow(d, compound.func_74775_l("Flows").func_74760_g(d.func_176610_l()));
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        CompoundNBT flows = new CompoundNBT();
        for (Direction d : Iterate.directions) {
            flows.func_74776_a(d.func_176610_l(), this.flows.get(d).floatValue());
        }
        compound.func_218657_a("Flows", (INBT)flows);
        super.write(compound, clientPacket);
    }

    public void setFlow(Direction direction, float speed) {
        this.flows.put(direction, Float.valueOf(speed));
        this.func_70296_d();
    }

    @Override
    public float getGeneratedSpeed() {
        float speed = 0.0f;
        for (Float f : this.flows.values()) {
            speed += f.floatValue();
        }
        if (speed != 0.0f) {
            speed += (float)((Integer)AllConfigs.SERVER.kinetics.waterWheelBaseSpeed.get()).intValue() * Math.signum(speed);
        }
        return speed;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        ((WaterWheelBlock)AllBlocks.WATER_WHEEL.get()).updateAllSides(this.func_195044_w(), this.field_145850_b, this.field_174879_c);
    }
}

