/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.content.contraptions.fluids.particle.FluidStackParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleData;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleData
implements IParticleData,
ICustomParticleData<FluidParticleData> {
    private ParticleType<FluidParticleData> type;
    private FluidStack fluid;
    public static final IParticleData.IDeserializer<FluidParticleData> DESERIALIZER = new IParticleData.IDeserializer<FluidParticleData>(){

        public FluidParticleData deserialize(ParticleType<FluidParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FluidParticleData(particleTypeIn, new FluidStack((Fluid)Fluids.field_204546_a, 1));
        }

        public FluidParticleData read(ParticleType<FluidParticleData> particleTypeIn, PacketBuffer buffer) {
            return new FluidParticleData(particleTypeIn, buffer.readFluidStack());
        }
    };

    public FluidParticleData() {
    }

    public FluidParticleData(ParticleType<?> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IParticleFactory<FluidParticleData> getFactory() {
        return (data, world, x, y, z, vx, vy, vz) -> FluidStackParticle.create(data.type, world, data.fluid, x, y, z, vx, vy, vz);
    }

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFluidStack(this.fluid);
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.type) + " " + this.fluid.getFluid().getRegistryName();
    }

    @Override
    public IParticleData.IDeserializer<FluidParticleData> getDeserializer() {
        return DESERIALIZER;
    }
}

