/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.LerpedFloat;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class FluidValveTileEntity
extends KineticTileEntity {
    LerpedFloat pointer = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public FluidValveTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        this.pointer.chase(speed > 0.0f ? 1.0 : 0.0, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.pointer.tickChaser();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof FluidValveBlock)) {
            return;
        }
        boolean stateOpen = (Boolean)blockState.func_177229_b((IProperty)FluidValveBlock.ENABLED);
        if (stateOpen && this.pointer.getValue() == 0.0f) {
            FluidValveTileEntity.switchToBlockState(this.field_145850_b, this.field_174879_c, (BlockState)blockState.func_206870_a((IProperty)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!stateOpen && this.pointer.getValue() == 1.0f) {
            FluidValveTileEntity.switchToBlockState(this.field_145850_b, this.field_174879_c, (BlockState)blockState.func_206870_a((IProperty)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
            return;
        }
    }

    private float getChaseSpeed() {
        return MathHelper.func_76131_a((float)(Math.abs(this.getSpeed()) / 16.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("Pointer", (INBT)this.pointer.writeNBT());
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.pointer.readNBT(compound.func_74775_l("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
    }

    class ValvePipeBehaviour
    extends StraightPipeTileEntity.StraightPipeFluidTransportBehaviour {
        public ValvePipeBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.func_176740_k();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (state.func_196959_b((IProperty)FluidValveBlock.ENABLED) && ((Boolean)state.func_177229_b((IProperty)FluidValveBlock.ENABLED)).booleanValue()) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }
    }
}

