/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.potion;

import com.google.common.collect.Lists;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluidHandler {
    public static Pair<FluidStack, ItemStack> emptyPotion(ItemStack stack, boolean simulate) {
        FluidStack fluid = PotionFluidHandler.getFluidFromPotionItem(stack);
        if (!simulate) {
            stack.func_190918_g(1);
        }
        return Pair.of(fluid, new ItemStack((IItemProvider)Items.field_151069_bo));
    }

    public static FluidIngredient potionIngredient(Potion potion, int amount) {
        return FluidIngredient.fromFluidStack(FluidHelper.copyStackWithAmount(PotionFluidHandler.getFluidFromPotionItem(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)potion)), amount));
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack) {
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        List list = PotionUtils.func_185190_b((ItemStack)stack);
        FluidStack fluid = PotionFluid.withEffects(250, potion, list);
        PotionFluid.BottleType bottleTypeFromItem = PotionFluidHandler.bottleTypeFromItem(stack);
        if (potion == Potions.field_185230_b && list.isEmpty() && bottleTypeFromItem == PotionFluid.BottleType.REGULAR) {
            return new FluidStack((Fluid)Fluids.field_204546_a, fluid.getAmount());
        }
        NBTHelper.writeEnum(fluid.getOrCreateTag(), "Bottle", bottleTypeFromItem);
        return fluid;
    }

    public static PotionFluid.BottleType bottleTypeFromItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_185156_bI) {
            return PotionFluid.BottleType.LINGERING;
        }
        if (item == Items.field_185155_bH) {
            return PotionFluid.BottleType.SPLASH;
        }
        return PotionFluid.BottleType.REGULAR;
    }

    public static IItemProvider itemFromBottleType(PotionFluid.BottleType type) {
        switch (type) {
            case LINGERING: {
                return Items.field_185156_bI;
            }
            case SPLASH: {
                return Items.field_185155_bH;
            }
        }
        return Items.field_151068_bn;
    }

    public static int getRequiredAmountForFilledBottle(ItemStack stack, FluidStack availableFluid) {
        return 250;
    }

    public static ItemStack fillBottle(ItemStack stack, FluidStack availableFluid) {
        CompoundNBT tag = availableFluid.getOrCreateTag();
        ItemStack potionStack = new ItemStack(PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", PotionFluid.BottleType.class)));
        PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)PotionUtils.func_185187_c((CompoundNBT)tag));
        PotionUtils.func_185184_a((ItemStack)potionStack, (Collection)PotionUtils.func_185192_b((CompoundNBT)tag));
        return potionStack;
    }

    public static ITextComponent getPotionName(FluidStack fs) {
        CompoundNBT tag = fs.getOrCreateTag();
        IItemProvider itemFromBottleType = PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", PotionFluid.BottleType.class));
        return new TranslationTextComponent(PotionUtils.func_185187_c((CompoundNBT)tag).func_185174_b(itemFromBottleType.func_199767_j().func_77658_a() + ".effect."), new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(FluidStack fs, List<ITextComponent> tooltip, float p_185182_2_) {
        List list = PotionUtils.func_185185_a((CompoundNBT)fs.getOrCreateTag());
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent itextcomponent = new TranslationTextComponent(effectinstance.func_76453_d(), new Object[0]);
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c(), new Object[0]));
                }
                if (effectinstance.func_76459_b() > 20) {
                    itextcomponent.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)p_185182_2_)).func_150258_a(")");
                }
                tooltip.add(itextcomponent.func_211708_a(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(new TranslationTextComponent("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.RED));
            }
        }
    }
}

