/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankRenderer
extends SafeTileEntityRenderer<FluidTankTileEntity> {
    public FluidTankRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(FluidTankTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        if (!te.window) {
            return;
        }
        InterpolatedChasingValue fluidLevel = te.fluidLevel;
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)te.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.get(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = MathHelper.func_76131_a((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = te.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getAttributes().isLighterThanAir();
        float xMin = tankHullWidth;
        float xMax = xMin + (float)te.width - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)te.width - 2.0f * tankHullWidth;
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, (double)(clampedLevel - totalHeight), 0.0);
        FluidRenderer.renderTiledFluidBB(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false);
        ms.func_227865_b_();
    }

    public boolean isGlobalRenderer(FluidTankTileEntity te) {
        return te.isController();
    }
}

