/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GoggleOverlayRenderer {
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.outliner.getOutlines();

    @SubscribeEvent
    public static void lookingAtBlocksThroughGogglesShowsTooltip(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        ItemStack headSlot = mc.field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        TileEntity te = world.func_175625_s(pos);
        boolean wearingGoggles = AllItems.GOGGLES.isIn(headSlot);
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<String> tooltip = new ArrayList<String>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add("");
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.func_177229_b((IProperty)PistonExtensionPoleBlock.field_176387_N)).func_176740_k());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((World)world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.func_180495_p(pos.func_177967_a(dir, attachedPoles + 1)).func_177230_c() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add("");
            }
            tooltip.add("    " + Lang.translate("gui.goggles.pole_length", new Object[0]) + " " + poles);
        }
        if (tooltip.isEmpty()) {
            return;
        }
        RenderSystem.pushMatrix();
        TooltipScreen tooltipScreen = new TooltipScreen(null);
        tooltipScreen.init(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
        int posX = tooltipScreen.width / 2 + (Integer)AllConfigs.CLIENT.overlayOffsetX.get();
        int posY = tooltipScreen.height / 2 + (Integer)AllConfigs.CLIENT.overlayOffsetY.get();
        tooltipScreen.renderTooltip(tooltip, posX, posY);
        ItemStack item = AllItems.GOGGLES.asStack();
        GuiGameElement.of(item).at(posX + 10, posY - 16).render();
        RenderSystem.popMatrix();
    }

    private static final class TooltipScreen
    extends Screen {
        private TooltipScreen(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void init(Minecraft mc, int width, int height) {
            this.minecraft = mc;
            this.itemRenderer = mc.func_175599_af();
            this.font = mc.field_71466_p;
            this.width = width;
            this.height = height;
        }
    }
}

