/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class EmptyingByBasin {
    static RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static boolean canItemBeEmptied(World world, ItemStack stack) {
        if (stack.func_77973_b() instanceof PotionItem) {
            return true;
        }
        wrapper.func_70299_a(0, stack);
        if (AllRecipeTypes.EMPTYING.find(wrapper, world).isPresent()) {
            return true;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            if (tank.getFluidInTank(i).getAmount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static Pair<FluidStack, ItemStack> emptyItem(World world, ItemStack stack, boolean simulate) {
        FluidStack resultingFluid = FluidStack.EMPTY;
        ItemStack resultingItem = ItemStack.field_190927_a;
        if (stack.func_77973_b() instanceof PotionItem) {
            return PotionFluidHandler.emptyPotion(stack, simulate);
        }
        wrapper.func_70299_a(0, stack);
        Optional recipe = AllRecipeTypes.EMPTYING.find(wrapper, world);
        if (recipe.isPresent()) {
            EmptyingRecipe emptyingRecipe = (EmptyingRecipe)recipe.get();
            List<ItemStack> results = emptyingRecipe.rollResults();
            if (!simulate) {
                stack.func_190918_g(1);
            }
            resultingItem = results.isEmpty() ? ItemStack.field_190927_a : results.get(0);
            resultingFluid = emptyingRecipe.getResultingFluid();
            return Pair.of(resultingFluid, resultingItem);
        }
        ItemStack split = stack.func_77946_l();
        split.func_190920_e(1);
        LazyOptional capability = split.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return Pair.of(resultingFluid, resultingItem);
        }
        resultingFluid = tank.drain(1000, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        resultingItem = tank.getContainer().func_77946_l();
        if (!simulate) {
            stack.func_190918_g(1);
        }
        return Pair.of(resultingFluid, resultingItem);
    }
}

