/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogwheelBlockItem;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpeedControllerBlock
extends HorizontalAxisKineticBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SpeedControllerBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ROTATION_SPEED_CONTROLLER.create();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState above = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a());
        if (CogWheelBlock.isLargeCog(above) && ((Direction.Axis)above.func_177229_b((IProperty)CogWheelBlock.AXIS)).func_176722_c()) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_AXIS, (Comparable)(above.func_177229_b((IProperty)CogWheelBlock.AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.func_196258_a(context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack heldItem;
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem = player.func_184586_b(hand))) {
            PlacementOffset offset = helper.getOffset(world, state, pos, ray);
            if (!offset.isReplaceable(world)) {
                return ActionResultType.PASS;
            }
            offset.placeInWorld(world, AllBlocks.LARGE_COGWHEEL.getDefaultState(), player, heldItem);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.SPEED_CONTROLLER.get((Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.LARGE_COGWHEEL::isIn;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return AllBlocks.ROTATION_SPEED_CONTROLLER::has;
        }

        @Override
        public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction.Axis newAxis;
            BlockPos newPos = pos.func_177984_a();
            if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = newAxis = state.func_177229_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            if (CogwheelBlockItem.DiagonalCogHelper.hasLargeCogwheelNeighbor(world, newPos, newAxis) || CogwheelBlockItem.DiagonalCogHelper.hasSmallCogwheelNeighbor(world, newPos, newAxis)) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a((IProperty)CogWheelBlock.AXIS, (Comparable)newAxis));
        }

        @Override
        public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
            IPlacementHelper.renderArrow(VecHelper.getCenterOf((Vec3i)pos), VecHelper.getCenterOf(offset.getPos()), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)(state.func_177229_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)));
        }
    }
}

