/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.logistics.InWorldProcessing;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class TransportedItemStack
implements Comparable<TransportedItemStack> {
    private static Random R = new Random();
    public ItemStack stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public Direction insertedFrom;
    public boolean locked;
    public float prevBeltPosition;
    public float prevSideOffset;
    public InWorldProcessing.Type processedBy;
    public int processingTime;

    public TransportedItemStack(ItemStack stack) {
        this.stack = stack;
        boolean centered = BeltHelper.isItemUpright(stack);
        this.angle = centered ? 180 : R.nextInt(360);
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = Direction.UP;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return this.beltPosition < o.beltPosition ? 1 : (this.beltPosition > o.beltPosition ? -1 : 0);
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(this.stack.func_77946_l());
        copy.beltPosition = this.beltPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevBeltPosition = this.prevBeltPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processedBy = this.processedBy;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Item", (INBT)this.stack.serializeNBT());
        nbt.func_74776_a("Pos", this.beltPosition);
        nbt.func_74776_a("PrevPos", this.prevBeltPosition);
        nbt.func_74776_a("Offset", this.sideOffset);
        nbt.func_74776_a("PrevOffset", this.prevSideOffset);
        nbt.func_74768_a("InSegment", this.insertedAt);
        nbt.func_74768_a("Angle", this.angle);
        nbt.func_74768_a("InDirection", this.insertedFrom.func_176745_a());
        nbt.func_74757_a("Locked", this.locked);
        return nbt;
    }

    public static TransportedItemStack read(CompoundNBT nbt) {
        TransportedItemStack stack = new TransportedItemStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item")));
        stack.beltPosition = nbt.func_74760_g("Pos");
        stack.prevBeltPosition = nbt.func_74760_g("PrevPos");
        stack.sideOffset = nbt.func_74760_g("Offset");
        stack.prevSideOffset = nbt.func_74760_g("PrevOffset");
        stack.insertedAt = nbt.func_74762_e("InSegment");
        stack.angle = nbt.func_74762_e("Angle");
        stack.insertedFrom = Direction.func_82600_a((int)nbt.func_74762_e("InDirection"));
        stack.locked = nbt.func_74767_n("Locked");
        return stack;
    }
}

