/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CogwheelBlockItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogwheelBlockItem(CogWheelBlock block, Item.Properties builder) {
        super((Block)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register(this.large ? new LargeCogHelper() : new SmallCogHelper());
        this.integratedCogHelperId = this.large ? PlacementHelpers.register(new IntegratedCogHelper()) : -1;
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState state = world.func_180495_p(pos);
        IPlacementHelper helper = PlacementHelpers.get(this.placementHelperId);
        PlayerEntity player = context.func_195999_j();
        if (helper.matchesState(state)) {
            PlacementOffset offset = helper.getOffset(world, state, pos, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), pos, true));
            if (!offset.isReplaceable(world)) {
                return super.func_195942_a(context);
            }
            offset.placeInWorld(world, this, player, context.func_195996_i());
            this.triggerShiftingGearsAdvancement(world, new BlockPos(offset.getPos()), offset.getTransform().apply(this.func_179223_d().func_176223_P()), player);
            return ActionResultType.SUCCESS;
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get(this.integratedCogHelperId)).matchesState(state)) {
            PlacementOffset offset = helper.getOffset(world, state, pos, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), pos, true));
            if (!offset.isReplaceable(world)) {
                return super.func_195942_a(context);
            }
            offset.placeInWorld(world, this, player, context.func_195996_i());
            this.triggerShiftingGearsAdvancement(world, new BlockPos(offset.getPos()), offset.getTransform().apply(this.func_179223_d().func_176223_P()), player);
            return ActionResultType.SUCCESS;
        }
        return super.func_195942_a(context);
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        this.triggerShiftingGearsAdvancement(context.func_195991_k(), context.func_195995_a(), state, context.func_195999_j());
        return super.func_195941_b(context, state);
    }

    protected void triggerShiftingGearsAdvancement(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (world.field_72995_K || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((IProperty)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.func_177967_a(d1, offset1).func_177967_a(d2, offset2);
                        BlockState blockState = world.func_180495_p(connectedPos);
                        if (!(blockState.func_177230_c() instanceof CogWheelBlock) || blockState.func_177229_b((IProperty)CogWheelBlock.AXIS) != axis || AllBlocks.LARGE_COGWHEEL.has(blockState) == this.large) continue;
                        AllTriggers.triggerFor(AllTriggers.SHIFTING_GEARS, player);
                    }
                }
            }
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.LARGE_COGWHEEL::isIn;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !AllBlocks.COGWHEEL.has((BlockState)s) && s.func_177230_c() instanceof IRotate && ((IRotate)s.func_177230_c()).hasIntegratedCogwheel(null, null, null);
        }

        @Override
        public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction face = ray.func_216354_b();
            Direction.Axis newAxis = state.func_196959_b(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k() : (state.func_196959_b((IProperty)DirectionalKineticBlock.FACING) ? ((Direction)state.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176740_k() : Direction.Axis.Y);
            if (face.func_176740_k() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), face.func_176740_k(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.func_177972_a(face).func_177972_a(d);
                if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                if (DiagonalCogHelper.hasLargeCogwheelNeighbor(world, newPos, newAxis) || DiagonalCogHelper.hasSmallCogwheelNeighbor(world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a((IProperty)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }

        @Override
        public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
            IPlacementHelper.renderArrow(VecHelper.getCenterOf((Vec3i)pos), VecHelper.getCenterOf(offset.getPos()), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)offset.getTransform().apply(AllBlocks.LARGE_COGWHEEL.getDefaultState()).func_177229_b(RotatedPillarKineticBlock.AXIS))));
        }
    }

    @MethodsReturnNonnullByDefault
    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.func_177230_c() instanceof CogWheelBlock;
        }

        @Override
        public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction closest = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).get(0);
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS), (Direction d) -> d.func_176740_k() != closest.func_176740_k());
            for (Direction dir : directions) {
                BlockPos newPos = pos.func_177972_a(dir).func_177972_a(closest);
                if (!world.func_180495_p(newPos).func_185904_a().func_76222_j() || AllBlocks.COGWHEEL.has(state) && DiagonalCogHelper.hasSmallCogwheelNeighbor(world, newPos, (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS))) continue;
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, state.func_177229_b(RotatedPillarKineticBlock.AXIS)));
            }
            return PlacementOffset.fail();
        }

        @Override
        public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
            IPlacementHelper.renderArrow(VecHelper.getCenterOf((Vec3i)pos), VecHelper.getCenterOf(offset.getPos()), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS))), 1.0);
        }

        protected boolean hitOnShaft(BlockState state, BlockRayTraceResult ray) {
            return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).func_197752_a().func_186662_g(0.001).func_72318_a(ray.func_216347_e().func_178788_d(ray.func_216347_e().func_197746_a(Iterate.axisSet)));
        }

        public static boolean hasLargeCogwheelNeighbor(World world, BlockPos pos, Direction.Axis axis) {
            for (Direction dir : Iterate.directions) {
                if (dir.func_176740_k() == axis || !AllBlocks.LARGE_COGWHEEL.has(world.func_180495_p(pos.func_177972_a(dir)))) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSmallCogwheelNeighbor(World world, BlockPos pos, Direction.Axis axis) {
            for (Direction dir : Iterate.directions) {
                if (dir.func_176740_k() == axis || !AllBlocks.COGWHEEL.has(world.func_180495_p(pos.func_177972_a(dir)))) continue;
                return true;
            }
            return false;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.LARGE_COGWHEEL::isIn;
        }

        @Override
        public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (((CogWheelBlock)state.func_177230_c()).isLarge) {
                Direction side = IPlacementHelper.orderedByDistanceOnlyAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)).get(0);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS));
                for (Direction dir : directions) {
                    BlockPos newPos = pos.func_177972_a(dir).func_177972_a(side);
                    if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, (Comparable)dir.func_176740_k()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(world, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.COGWHEEL::isIn;
        }

        @Override
        public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!((CogWheelBlock)state.func_177230_c()).isLarge) {
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS));
                for (Direction dir : directions) {
                    BlockPos newPos = pos.func_177972_a(dir);
                    if (SmallCogHelper.hasLargeCogwheelNeighbor(world, newPos, (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS)) || !world.func_180495_p(newPos).func_185904_a().func_76222_j()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a(RotatedPillarKineticBlock.AXIS, state.func_177229_b(RotatedPillarKineticBlock.AXIS)));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(world, state, pos, ray);
        }

        @Override
        public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
            IPlacementHelper.renderArrow(VecHelper.getCenterOf((Vec3i)pos), VecHelper.getCenterOf(offset.getPos()), Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS))), ((CogWheelBlock)state.func_177230_c()).isLarge ? 1.5 : 0.75);
        }
    }
}

