/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TextFormatting;

public class StressGaugeTileEntity
extends GaugeTileEntity {
    public StressGaugeTileEntity(TileEntityType<? extends StressGaugeTileEntity> type) {
        super(type);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? ColorHelper.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? ColorHelper.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.func_70296_d();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.func_70296_d();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        tooltip.add("    " + TextFormatting.GRAY + Lang.translate("gui.stressometer.title", new Object[0]));
        if (this.getTheoreticalSpeed() == 0.0f) {
            tooltip.add("    " + TextFormatting.DARK_GRAY + ItemDescription.makeProgressBar(3, -1) + Lang.translate("gui.stressometer.no_rotation", new Object[0]));
        } else {
            tooltip.add("    " + IRotate.StressImpact.getFormattedStressText(stressFraction));
            tooltip.add("    " + TextFormatting.GRAY + Lang.translate("gui.stressometer.capacity", new Object[0]));
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            String su = Lang.translate("generic.unit.stress", new Object[0]);
            if (remainingCapacity != capacity) {
                String capacityString = "    " + IRotate.StressImpact.of(stressFraction).getRelativeColor() + "%s" + su + TextFormatting.GRAY + " / " + TextFormatting.DARK_GRAY + "%s" + su;
                tooltip.add(" " + String.format(capacityString, IHaveGoggleInformation.format(remainingCapacity), IHaveGoggleInformation.format(capacity)));
            } else {
                String capacityString = "    " + IRotate.StressImpact.of(stressFraction).getRelativeColor() + "%s" + su;
                tooltip.add(" " + String.format(capacityString, IHaveGoggleInformation.format(remainingCapacity)));
            }
        }
        return true;
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }
}

