/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;

public interface IWrenchableWithBracket
extends IWrenchable {
    public Optional<ItemStack> removeBracket(IBlockReader var1, BlockPos var2, boolean var3);

    @Override
    default public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (this.tryRemoveBracket(context)) {
            return ActionResultType.SUCCESS;
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    default public boolean tryRemoveBracket(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Optional<ItemStack> bracket = this.removeBracket((IBlockReader)world, pos, false);
        BlockState blockState = world.func_180495_p(pos);
        if (bracket.isPresent()) {
            PlayerEntity player = context.func_195999_j();
            if (!world.field_72995_K && !player.func_184812_l_()) {
                player.field_71071_by.func_191975_a(world, bracket.get());
            }
            if (!world.field_72995_K && AllBlocks.FLUID_PIPE.has(blockState)) {
                Direction.Axis preferred = FluidPropagator.getStraightPipeAxis(blockState);
                Direction preferredDirection = preferred == null ? Direction.UP : Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)preferred);
                BlockState updated = ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(blockState, preferredDirection, null, (ILightReader)world, pos);
                if (updated != blockState) {
                    world.func_175656_a(pos, updated);
                }
            }
            return true;
        }
        return false;
    }
}

