/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry.mirror;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PlaneMirror
extends SymmetryMirror {
    public PlaneMirror(Vec3d pos) {
        super(pos);
        this.orientation = Align.XY;
    }

    @Override
    protected void setOrientation() {
        if (this.orientationIndex < 0) {
            this.orientationIndex += Align.values().length;
        }
        if (this.orientationIndex >= Align.values().length) {
            this.orientationIndex -= Align.values().length;
        }
        this.orientation = Align.values()[this.orientationIndex];
    }

    @Override
    public void setOrientation(int index) {
        this.orientation = Align.values()[index];
        this.orientationIndex = index;
    }

    @Override
    public Map<BlockPos, BlockState> process(BlockPos position, BlockState block) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        switch ((Align)this.orientation) {
            case XY: {
                result.put(this.flipZ(position), this.flipZ(block));
                break;
            }
            case YZ: {
                result.put(this.flipX(position), this.flipX(block));
                break;
            }
        }
        return result;
    }

    @Override
    public String typeName() {
        return "plane";
    }

    @Override
    public AllBlockPartials getModel() {
        return AllBlockPartials.SYMMETRY_PLANE;
    }

    @Override
    public void applyModelTransform(MatrixStack ms) {
        super.applyModelTransform(ms);
        MatrixStacker.of(ms).centre().rotateY((Align)this.orientation == Align.XY ? 0.0 : 90.0).unCentre();
    }

    @Override
    public List<String> getAlignToolTips() {
        return ImmutableList.of((Object)Lang.translate("orientation.alongZ", new Object[0]), (Object)Lang.translate("orientation.alongX", new Object[0]));
    }

    public static enum Align implements IStringSerializable
    {
        XY("xy"),
        YZ("yz");

        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

