/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.blockzapper;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.content.curiosities.zapper.ZapperInteractionHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperScreen;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockzapperItem
extends ZapperItem {
    public BlockzapperItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ItemDescription.Palette palette = ItemDescription.Palette.Purple;
        if (Screen.hasShiftDown()) {
            ItemDescription.add(tooltip, palette.color + Lang.translate("blockzapper.componentUpgrades", new Object[0]));
            for (Components c : Components.values()) {
                ComponentTier tier = BlockzapperItem.getTier(c, stack);
                String componentName = TextFormatting.GRAY + Lang.translate("blockzapper.component." + Lang.asId(c.name()), new Object[0]);
                String tierName = tier.color + Lang.translate("blockzapper.componentTier." + Lang.asId(tier.name()), new Object[0]);
                ItemDescription.add(tooltip, "> " + componentName + ": " + tierName);
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group != Create.baseCreativeTab && group != ItemGroup.field_78027_g) {
            return;
        }
        ItemStack gunWithoutStuff = new ItemStack((IItemProvider)this);
        items.add((Object)gunWithoutStuff);
        ItemStack gunWithGoldStuff = new ItemStack((IItemProvider)this);
        for (Components c : Components.values()) {
            BlockzapperItem.setTier(c, ComponentTier.Brass, gunWithGoldStuff);
        }
        items.add((Object)gunWithGoldStuff);
        ItemStack gunWithPurpurStuff = new ItemStack((IItemProvider)this);
        for (Components c : Components.values()) {
            BlockzapperItem.setTier(c, ComponentTier.Chromatic, gunWithPurpurStuff);
        }
        items.add((Object)gunWithPurpurStuff);
    }

    @Override
    protected boolean activate(World world, PlayerEntity player, ItemStack stack, BlockState selectedState, BlockRayTraceResult raytrace, CompoundNBT data) {
        CompoundNBT nbt = stack.func_196082_o();
        boolean replace = nbt.func_74764_b("Replace") && nbt.func_74767_n("Replace");
        List<BlockPos> selectedBlocks = BlockzapperItem.getSelectedBlocks(stack, world, player);
        PlacementPatterns.applyPattern(selectedBlocks, stack);
        Direction face = raytrace.func_216354_b();
        for (BlockPos placed : selectedBlocks) {
            if (world.func_180495_p(placed) == selectedState || !selectedState.func_196955_c((IWorldReader)world, placed) || !player.func_184812_l_() && !BlockzapperItem.canBreak(stack, world.func_180495_p(placed), world, placed)) continue;
            if (!player.func_184812_l_() && BlockHelper.findAndRemoveInInventory(selectedState, player, 1) == 0) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + Lang.translate("blockzapper.empty", new Object[0])), true);
                return false;
            }
            if (!player.func_184812_l_() && replace) {
                BlockzapperItem.dropBlocks(world, player, stack, face, placed);
            }
            BlockState state = selectedState;
            for (Direction updateDirection : Iterate.directions) {
                state = state.func_196956_a(updateDirection, world.func_180495_p(placed.func_177972_a(updateDirection)), (IWorld)world, placed, placed.func_177972_a(updateDirection));
            }
            BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)placed);
            IFluidState ifluidstate = world.func_204610_c(placed);
            world.func_180501_a(placed, ifluidstate.func_206883_i(), 16);
            world.func_175656_a(placed, state);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(true, false);
                return false;
            }
            BlockzapperItem.setTileData(world, placed, data);
            if (!(player instanceof ServerPlayerEntity) || !(world instanceof ServerWorld)) continue;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            CriteriaTriggers.field_193137_x.func_193173_a(serverPlayer, placed, new ItemStack((IItemProvider)state.func_177230_c()));
            boolean fullyUpgraded = true;
            for (Components c : Components.values()) {
                if (BlockzapperItem.getTier(c, stack) == ComponentTier.Chromatic) continue;
                fullyUpgraded = false;
                break;
            }
            if (!fullyUpgraded) continue;
            AllTriggers.UPGRADED_ZAPPER.trigger(serverPlayer);
        }
        for (BlockPos placed : selectedBlocks) {
            world.func_190524_a(placed, selectedState.func_177230_c(), placed);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (AllItems.BLOCKZAPPER.isIn(stack)) {
            CompoundNBT nbt = stack.func_196082_o();
            if (!nbt.func_74764_b("Replace")) {
                nbt.func_74757_a("Replace", false);
            }
            if (!nbt.func_74764_b("Pattern")) {
                nbt.func_74778_a("Pattern", PlacementPatterns.Solid.name());
            }
            if (!nbt.func_74764_b("SearchDiagonal")) {
                nbt.func_74757_a("SearchDiagonal", false);
            }
            if (!nbt.func_74764_b("SearchMaterial")) {
                nbt.func_74757_a("SearchMaterial", false);
            }
            if (!nbt.func_74764_b("SearchDistance")) {
                nbt.func_74768_a("SearchDistance", 1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void openHandgunGUI(ItemStack handgun, boolean offhand) {
        ScreenOpener.open(new BlockzapperScreen(handgun, offhand));
    }

    public static List<BlockPos> getSelectedBlocks(ItemStack stack, World worldIn, PlayerEntity player) {
        Vec3d range;
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return list;
        }
        boolean searchDiagonals = tag.func_74764_b("SearchDiagonal") && tag.func_74767_n("SearchDiagonal");
        boolean searchAcrossMaterials = tag.func_74764_b("SearchFuzzy") && tag.func_74767_n("SearchFuzzy");
        boolean replace = tag.func_74764_b("Replace") && tag.func_74767_n("Replace");
        int searchRange = tag.func_74764_b("SearchDistance") ? tag.func_74762_e("SearchDistance") : 0;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        Vec3d start = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        BlockRayTraceResult raytrace = player.field_70170_p.func_217299_a(new RayTraceContext(start, start.func_178787_e(range = player.func_70040_Z().func_186678_a((double)ZapperInteractionHandler.getRange(stack))), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        BlockPos pos = raytrace.func_216350_a().func_185334_h();
        if (pos == null) {
            return list;
        }
        BlockState state = worldIn.func_180495_p(pos);
        Direction face = raytrace.func_216354_b();
        LinkedList<BlockPos> offsets = new LinkedList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2 && !searchDiagonals || face.func_176740_k().func_196052_a(x, y, z) != 0) continue;
                    offsets.add(new BlockPos(x, y, z));
                }
            }
        }
        BlockPos startPos = replace ? pos : pos.func_177972_a(face);
        frontier.add(startPos);
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!currentPos.func_218141_a((Vec3i)startPos, (double)searchRange)) continue;
            if (replace) {
                BlockState stateToReplace = worldIn.func_180495_p(currentPos);
                BlockState stateAboveStateToReplace = worldIn.func_180495_p(currentPos.func_177972_a(face));
                if (stateToReplace.func_185887_b((IBlockReader)worldIn, currentPos) == -1.0f || stateToReplace.func_177230_c() != state.func_177230_c() && !searchAcrossMaterials || stateToReplace.func_185904_a().func_76222_j() || stateAboveStateToReplace.func_200132_m()) continue;
                list.add(currentPos);
                for (BlockPos offset : offsets) {
                    frontier.add(currentPos.func_177971_a((Vec3i)offset));
                }
                continue;
            }
            BlockState stateToPlaceAt = worldIn.func_180495_p(currentPos);
            BlockState stateToPlaceOn = worldIn.func_180495_p(currentPos.func_177972_a(face.func_176734_d()));
            if (stateToPlaceOn.func_185904_a().func_76222_j() || stateToPlaceOn.func_177230_c() != state.func_177230_c() && !searchAcrossMaterials || !stateToPlaceAt.func_185904_a().func_76222_j()) continue;
            list.add(currentPos);
            for (BlockPos offset : offsets) {
                frontier.add(currentPos.func_177971_a((Vec3i)offset));
            }
        }
        return list;
    }

    public static boolean canBreak(ItemStack stack, BlockState state, World world, BlockPos pos) {
        ComponentTier tier = BlockzapperItem.getTier(Components.Body, stack);
        float blockHardness = state.func_185887_b((IBlockReader)world, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        if (tier == ComponentTier.None) {
            return blockHardness < 3.0f;
        }
        if (tier == ComponentTier.Brass) {
            return blockHardness < 6.0f;
        }
        return tier == ComponentTier.Chromatic;
    }

    public static int getMaxAoe(ItemStack stack) {
        ComponentTier tier = BlockzapperItem.getTier(Components.Amplifier, stack);
        if (tier == ComponentTier.None) {
            return 2;
        }
        if (tier == ComponentTier.Brass) {
            return 4;
        }
        if (tier == ComponentTier.Chromatic) {
            return 8;
        }
        return 0;
    }

    @Override
    protected int getCooldownDelay(ItemStack stack) {
        return BlockzapperItem.getCooldown(stack);
    }

    public static int getCooldown(ItemStack stack) {
        ComponentTier tier = BlockzapperItem.getTier(Components.Accelerator, stack);
        if (tier == ComponentTier.None) {
            return 10;
        }
        if (tier == ComponentTier.Brass) {
            return 6;
        }
        if (tier == ComponentTier.Chromatic) {
            return 2;
        }
        return 20;
    }

    @Override
    protected int getZappingRange(ItemStack stack) {
        ComponentTier tier = BlockzapperItem.getTier(Components.Scope, stack);
        if (tier == ComponentTier.None) {
            return 15;
        }
        if (tier == ComponentTier.Brass) {
            return 30;
        }
        if (tier == ComponentTier.Chromatic) {
            return 100;
        }
        return 0;
    }

    protected static void dropBlocks(World worldIn, PlayerEntity playerIn, ItemStack item, Direction face, BlockPos placed) {
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = worldIn.func_180495_p(placed).hasTileEntity() ? worldIn.func_175625_s(placed) : null;
        if (BlockzapperItem.getTier(Components.Retriever, item) == ComponentTier.None) {
            Block.func_220059_a((BlockState)worldIn.func_180495_p(placed), (World)worldIn, (BlockPos)placed.func_177972_a(face), (TileEntity)tileentity);
        }
        if (BlockzapperItem.getTier(Components.Retriever, item) == ComponentTier.Brass) {
            Block.func_220059_a((BlockState)worldIn.func_180495_p(placed), (World)worldIn, (BlockPos)playerIn.func_180425_c(), (TileEntity)tileentity);
        }
        if (BlockzapperItem.getTier(Components.Retriever, item) == ComponentTier.Chromatic) {
            for (ItemStack stack : Block.func_220070_a((BlockState)worldIn.func_180495_p(placed), (ServerWorld)((ServerWorld)worldIn), (BlockPos)placed, (TileEntity)tileentity)) {
                if (playerIn.field_71071_by.func_70441_a(stack)) continue;
                Block.func_180635_a((World)worldIn, (BlockPos)placed, (ItemStack)stack);
            }
        }
    }

    public static ComponentTier getTier(Components component, ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(component.name())) {
            stack.func_196082_o().func_74778_a(component.name(), ComponentTier.None.name());
        }
        return NBTHelper.readEnum(stack.func_77978_p(), component.name(), ComponentTier.class);
    }

    public static void setTier(Components component, ComponentTier tier, ItemStack stack) {
        NBTHelper.writeEnum(stack.func_196082_o(), component.name(), tier);
    }

    public static enum Components {
        Body,
        Amplifier,
        Accelerator,
        Retriever,
        Scope;

    }

    public static enum ComponentTier {
        None(TextFormatting.DARK_GRAY),
        Brass(TextFormatting.GOLD),
        Chromatic(TextFormatting.LIGHT_PURPLE);

        public TextFormatting color;

        private ComponentTier(TextFormatting color) {
            this.color = color;
        }
    }
}

