/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.ZapperScreen;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class WorldshaperScreen
extends ZapperScreen {
    protected final String placementSection = Lang.translate("gui.terrainzapper.placement", new Object[0]);
    protected final String toolSection = Lang.translate("gui.terrainzapper.tool", new Object[0]);
    protected final List<String> brushOptions = Lang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder");
    protected Vector<IconButton> toolButtons;
    protected Vector<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected Vector<ScrollInput> brushParams;
    protected Vector<Label> brushParamLabels;
    private int i;
    private int j;
    private CompoundNBT nbt;

    public WorldshaperScreen(ItemStack zapper, boolean offhand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, offhand);
        this.fontColor = 0x767676;
        this.title = Lang.translate("gui.terrainzapper.title", new Object[0]);
        this.nbt = zapper.func_196082_o();
    }

    @Override
    protected void init() {
        super.init();
        this.i = this.guiLeft - 20;
        this.j = this.guiTop;
        this.brushLabel = new Label(this.i + 61, this.j + 23, "").withShadow();
        this.brushInput = new SelectionScrollInput(this.i + 56, this.j + 18, 77, 18).forOptions(this.brushOptions).titled(Lang.translate("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(this::brushChanged);
        if (this.nbt.func_74764_b("Brush")) {
            this.brushInput.setState(NBTHelper.readEnum(this.nbt, "Brush", TerrainBrushes.class).ordinal());
        }
        this.widgets.add(this.brushLabel);
        this.widgets.add(this.brushInput);
        this.initBrushParams();
        this.toolButtons = new Vector(6);
        TerrainTools[] toolValues = TerrainTools.values();
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            this.toolButtons.add(new IconButton(this.i + 7 + id * 18, this.j + 77, tool.icon));
            this.toolButtons.get(id).setToolTip(Lang.translate("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
        }
        if (this.nbt.func_74764_b("Tool")) {
            this.toolButtons.get((int)NBTHelper.readEnum((CompoundNBT)this.nbt, (String)"Tool", TerrainTools.class).ordinal()).active = false;
        }
        this.widgets.addAll(this.toolButtons);
        this.placementButtons = new Vector(3);
        PlacementOptions[] placementValues = PlacementOptions.values();
        for (int id = 0; id < placementValues.length; ++id) {
            PlacementOptions option = placementValues[id];
            this.placementButtons.add(new IconButton(this.i + 136 + id * 18, this.j + 77, option.icon));
            this.placementButtons.get(id).setToolTip(Lang.translate("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
        }
        if (this.nbt.func_74764_b("Placement")) {
            this.placementButtons.get((int)NBTHelper.readEnum((CompoundNBT)this.nbt, (String)"Placement", PlacementOptions.class).ordinal()).active = false;
        }
        this.widgets.addAll(this.placementButtons);
    }

    public void initBrushParams() {
        if (this.brushParams != null) {
            this.nbt.func_218657_a("BrushParams", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(this.brushParams.get(0).getState(), this.brushParams.get(1).getState(), this.brushParams.get(2).getState())));
            this.widgets.removeAll(this.brushParamLabels);
            this.widgets.removeAll(this.brushParams);
        }
        this.brushParamLabels = new Vector(3);
        this.brushParams = new Vector(3);
        BlockPos data = NBTUtil.func_186861_c((CompoundNBT)this.nbt.func_74775_l("BrushParams"));
        int[] params = new int[]{data.func_177958_n(), data.func_177956_o(), data.func_177952_p()};
        Brush currentBrush = TerrainBrushes.values()[this.brushInput.getState()].get();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(this.i + 65 + 20 * index, this.j + 43, "").withShadow();
            this.brushParamLabels.add(label);
            int indexFinal = index;
            ScrollInput input = new ScrollInput(this.i + 56 + 20 * index, this.j + 38, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(currentBrush.getParamLabel(index)).calling(state -> {
                label.x = this.i + 65 + 20 * indexFinal - this.font.func_78256_a(label.text) / 2;
            });
            input.setState(params[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.visible = false;
                label.visible = false;
                input.active = false;
            }
            this.brushParams.add(input);
        }
        this.widgets.addAll(this.brushParamLabels);
        this.widgets.addAll(this.brushParams);
    }

    private void brushChanged(int brushIndex) {
        this.initBrushParams();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        CompoundNBT nbt = this.zapper.func_77978_p();
        for (IconButton placementButton : this.placementButtons) {
            if (!placementButton.isHovered()) continue;
            this.placementButtons.forEach(b -> {
                b.active = true;
            });
            placementButton.active = false;
            placementButton.playDownSound(Minecraft.func_71410_x().func_147118_V());
            nbt.func_74778_a("Placement", PlacementOptions.values()[this.placementButtons.indexOf((Object)placementButton)].name());
        }
        for (IconButton toolButton : this.toolButtons) {
            if (!toolButton.isHovered()) continue;
            this.toolButtons.forEach(b -> {
                b.active = true;
            });
            toolButton.active = false;
            toolButton.playDownSound(Minecraft.func_71410_x().func_147118_V());
            nbt.func_74778_a("Tool", TerrainTools.values()[this.toolButtons.indexOf((Object)toolButton)].name());
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    protected void drawOnBackground(int i, int j) {
        super.drawOnBackground(i, j);
        Brush currentBrush = TerrainBrushes.values()[this.brushInput.getState()].get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.draw(i + 56 + 20 * index, j + 38);
        }
        this.font.func_211126_b(this.toolSection, (float)(i + 7), (float)(j + 66), this.fontColor);
        this.font.func_211126_b(this.placementSection, (float)(i + 136), (float)(j + 66), this.fontColor);
    }

    @Override
    protected void writeAdditionalOptions(CompoundNBT nbt) {
        super.writeAdditionalOptions(nbt);
        NBTHelper.writeEnum(nbt, "Brush", TerrainBrushes.values()[this.brushInput.getState()]);
        nbt.func_218657_a("BrushParams", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(this.brushParams.get(0).getState(), this.brushParams.get(1).getState(), this.brushParams.get(2).getState())));
    }
}

