/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.depot.DepotTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DepotBlock
extends Block
implements ITE<DepotTileEntity>,
IWrenchable {
    public DepotBlock(Block.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.DEPOT;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.DEPOT.create();
    }

    @Override
    public Class<DepotTileEntity> getTileEntityClass() {
        return DepotTileEntity.class;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (ray.func_216354_b() != Direction.UP) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            ItemStack heldItem = player.func_184586_b(hand);
            boolean wasEmptyHanded = heldItem.func_190926_b();
            boolean shouldntPlaceItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem);
            ItemStack mainItemStack = te.getHeldItemStack();
            if (!mainItemStack.func_190926_b()) {
                player.field_71071_by.func_191975_a(world, mainItemStack);
                te.setHeldItem(null);
            }
            ItemStackHandler outputs = te.processingOutputBuffer;
            for (int i = 0; i < outputs.getSlots(); ++i) {
                player.field_71071_by.func_191975_a(world, outputs.extractItem(i, 64, false));
            }
            if (!wasEmptyHanded && !shouldntPlaceItem) {
                TransportedItemStack transported = new TransportedItemStack(heldItem);
                transported.insertedFrom = player.func_174811_aO();
                transported.prevBeltPosition = 0.25f;
                transported.beltPosition = 0.25f;
                te.setHeldItem(transported);
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            te.func_70296_d();
            te.sendData();
        });
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.processingOutputBuffer);
            if (!te.getHeldItemStack().func_190926_b()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getHeldItemStack());
            }
        });
        worldIn.func_175713_t(pos);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (!AllBlocks.DEPOT.has(worldIn.func_180495_p(entityIn.func_180425_c()))) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get(worldIn, entityIn.func_180425_c(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.func_92059_d(), Direction.DOWN, false);
        itemEntity.func_92058_a(remainder);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        try {
            return ItemHelper.calcRedstoneFromInventory(((DepotTileEntity)this.getTileEntity((IBlockReader)worldIn, (BlockPos)pos)).itemHandler);
        }
        catch (ITE.TileEntityException tileEntityException) {
            return 0;
        }
    }
}

