/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperDirectionalBlock;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class FunnelBlock
extends ProperDirectionalBlock
implements ITE<FunnelTileEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public FunnelBlock(Block.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195999_j() == null || context.func_195999_j().func_225608_bj_() ? context.func_196000_l() : context.func_196010_d().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)facing)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{POWERED}));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean shouldntInsertItem;
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean bl = shouldntInsertItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem) || !this.canInsertIntoFunnel(state);
        if (hit.func_216354_b() == FunnelBlock.getFunnelFacing(state) && !shouldntInsertItem) {
            if (!worldIn.field_72995_K) {
                this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                    ItemStack toInsert = heldItem.func_77946_l();
                    ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, toInsert, false);
                    if (!ItemStack.func_77989_b((ItemStack)remainder, (ItemStack)toInsert)) {
                        player.func_184611_a(handIn, remainder);
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!this.canInsertIntoFunnel(state)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        Direction direction = (Direction)state.func_177229_b((IProperty)field_176387_N);
        Vec3d diff = entityIn.func_213303_ch().func_178788_d(VecHelper.getCenterOf((Vec3i)pos));
        double projectedDiff = direction.func_176740_k().func_196051_a(diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
        if (projectedDiff < 0.0 == (direction.func_176743_c() == Direction.AxisDirection.POSITIVE)) {
            return;
        }
        ItemStack toInsert = itemEntity.func_92059_d();
        ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, toInsert, false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < toInsert.func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    public static ItemStack tryInsert(World worldIn, BlockPos pos, ItemStack toInsert, boolean simulate) {
        TileEntity tileEntity;
        FilteringBehaviour filter = TileEntityBehaviour.get((IBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
        InvManipulationBehaviour inserter = TileEntityBehaviour.get((IBlockReader)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (inserter == null) {
            return toInsert;
        }
        if (filter != null && !filter.test(toInsert)) {
            return toInsert;
        }
        if (simulate) {
            inserter.simulate();
        }
        ItemStack insert = inserter.insert(toInsert);
        if (!simulate && insert.func_190916_E() != toInsert.func_190916_E() && (tileEntity = worldIn.func_175625_s(pos)) instanceof FunnelTileEntity) {
            ((FunnelTileEntity)tileEntity).onTransfer(toInsert);
        }
        return insert;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FUNNEL.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return AllShapes.FUNNEL.get((Direction)state.func_177229_b((IProperty)field_176387_N));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof ItemEntity) {
            return AllShapes.FUNNEL_COLLISION.get((Direction)state.func_177229_b((IProperty)field_176387_N));
        }
        return this.func_220053_a(state, world, pos, context);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState p_196271_3_, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        BlockState equivalentFunnel;
        Direction facing = (Direction)state.func_177229_b((IProperty)field_176387_N);
        if (facing.func_176740_k().func_176722_c() && direction == Direction.DOWN && BeltFunnelBlock.isOnValidBelt(equivalentFunnel = this.getEquivalentBeltFunnel(null, null, state), (IWorldReader)world, pos)) {
            return (BlockState)equivalentFunnel.func_206870_a(BeltFunnelBlock.SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((IBlockReader)world, pos, facing)));
        }
        return state;
    }

    public abstract BlockState getEquivalentBeltFunnel(IBlockReader var1, BlockPos var2, BlockState var3);

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d())).func_177230_c();
        return !(block instanceof FunnelBlock) && !(block instanceof BeltFunnelBlock);
    }

    @Nullable
    public static Direction getFunnelFacing(BlockState state) {
        if (state.func_196959_b((IProperty)field_176387_N)) {
            return (Direction)state.func_177229_b((IProperty)field_176387_N);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            return (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        }
        return null;
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (p_196243_1_.hasTileEntity() && (p_196243_1_.func_177230_c() != p_196243_4_.func_177230_c() && !FunnelBlock.isFunnel(p_196243_4_) || !p_196243_4_.hasTileEntity())) {
            TileEntityBehaviour.destroy((IBlockReader)p_196243_2_, p_196243_3_, FilteringBehaviour.TYPE);
            p_196243_2_.func_175713_t(p_196243_3_);
        }
    }

    protected boolean canInsertIntoFunnel(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) == false;
    }

    @Nullable
    public static boolean isFunnel(BlockState state) {
        return state.func_177230_c() instanceof FunnelBlock || state.func_177230_c() instanceof BeltFunnelBlock;
    }

    @Override
    public Class<FunnelTileEntity> getTileEntityClass() {
        return FunnelTileEntity.class;
    }
}

