/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.inventories;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.BottomlessItemHandler;
import com.simibubi.create.content.logistics.block.inventories.CrateTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CreativeCrateTileEntity
extends CrateTileEntity {
    FilteringBehaviour filtering;
    LazyOptional<IItemHandler> itemHandler;
    private BottomlessItemHandler inv = new BottomlessItemHandler(this.filtering::getFilter);

    public CreativeCrateTileEntity(TileEntityType<? extends CreativeCrateTileEntity> type) {
        super(type);
        this.itemHandler = LazyOptional.of(() -> this.inv);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = this.createFilter().onlyActiveWhen(this::filterVisible).withCallback(this::filterChanged);
        behaviours.add(this.filtering);
    }

    private boolean filterVisible() {
        return this.func_145830_o() && (!this.isDoubleCrate() || this.isSecondaryCrate());
    }

    private void filterChanged(ItemStack filter) {
        if (!this.filterVisible()) {
            return;
        }
        CreativeCrateTileEntity otherCrate = this.getOtherCrate();
        if (otherCrate == null) {
            return;
        }
        if (ItemStack.func_179545_c((ItemStack)filter, (ItemStack)otherCrate.filtering.getFilter())) {
            return;
        }
        otherCrate.filtering.setFilter(filter);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    private CreativeCrateTileEntity getOtherCrate() {
        if (!AllBlocks.CREATIVE_CRATE.has(this.func_195044_w())) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tileEntity instanceof CreativeCrateTileEntity) {
            return (CreativeCrateTileEntity)tileEntity;
        }
        return null;
    }

    public void onPlaced() {
        if (!this.isDoubleCrate()) {
            return;
        }
        CreativeCrateTileEntity otherCrate = this.getOtherCrate();
        if (otherCrate == null) {
            return;
        }
        this.filtering.withCallback($ -> {});
        this.filtering.setFilter(otherCrate.filtering.getFilter());
        this.filtering.withCallback(this::filterChanged);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            protected void rotate(BlockState state, MatrixStack ms) {
                MatrixStacker.of(ms).rotateX(90.0);
            }

            @Override
            protected Vec3d getLocalOffset(BlockState state) {
                return new Vec3d(0.5, 0.8125, 0.5);
            }

            @Override
            protected float getScale() {
                return super.getScale() * 1.5f;
            }
        });
    }
}

