/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class NixieTubeBlock
extends HorizontalBlock
implements ITE<NixieTubeTileEntity> {
    public static final BooleanProperty CEILING = BooleanProperty.func_177716_a((String)"ceiling");

    public NixieTubeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)CEILING, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        try {
            ItemStack heldItem = player.func_184586_b(hand);
            NixieTubeTileEntity nixie = (NixieTubeTileEntity)this.getTileEntity((IBlockReader)world, pos);
            if (player.func_225608_bj_()) {
                return ActionResultType.PASS;
            }
            if (heldItem.func_190926_b()) {
                if (nixie.reactsToRedstone()) {
                    return ActionResultType.PASS;
                }
                nixie.clearCustomText();
                this.updateDisplayedRedstoneValue(state, world, pos);
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s()) {
                BlockPos nextPos;
                Direction left = ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176746_e();
                Direction right = left.func_176734_d();
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                BlockPos currentPos = pos;
                while (world.func_180495_p(nextPos = currentPos.func_177972_a(left)) == state) {
                    currentPos = nextPos;
                }
                int index = 0;
                while (true) {
                    int rowPosition = index++;
                    this.withTileEntityDo((IBlockReader)world, currentPos, te -> te.displayCustomNameOf(heldItem, rowPosition));
                    BlockPos nextPos2 = currentPos.func_177972_a(right);
                    if (world.func_180495_p(nextPos2) == state) {
                        currentPos = nextPos2;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new IProperty[]{CEILING, field_185512_D}));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return ((Boolean)state.func_177229_b((IProperty)CEILING) != false ? AllShapes.NIXIE_TUBE_CEILING : AllShapes.NIXIE_TUBE).get(((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        boolean ceiling = context.func_196000_l() == Direction.DOWN;
        Vec3d hitVec = context.func_221532_j();
        if (hitVec != null) {
            ceiling = hitVec.field_72448_b - (double)pos.func_177956_o() > 0.5;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)CEILING, (Comparable)Boolean.valueOf(ceiling));
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        this.updateDisplayedRedstoneValue(p_220069_1_, p_220069_2_, p_220069_3_);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new NixieTubeTileEntity((TileEntityType)AllTileEntities.NIXIE_TUBE.get());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    private void updateDisplayedRedstoneValue(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.reactsToRedstone()) {
                te.displayRedstoneStrength(this.getPower(worldIn, pos));
            }
        });
    }

    static boolean isValidBlock(IBlockReader world, BlockPos pos, boolean above) {
        BlockState state = world.func_180495_p(pos.func_177981_b(above ? 1 : -1));
        return !state.func_196954_c(world, pos).func_197766_b();
    }

    private int getPower(World worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeTileEntity> getTileEntityClass() {
        return NixieTubeTileEntity.class;
    }
}

